% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_soo_function.R
\name{plot_2d_soo_function}
\alias{plot_2d_soo_function}
\title{Plot a test function in 2D.}
\usage{
plot_2d_soo_function(
  fn,
  lower = lower_bounds(fn),
  upper = upper_bounds(fn),
  n = 10000L,
  main = function_name(fn),
  xlab = expression(x[1]),
  ylab = expression(x[2]),
  log = FALSE,
  rank = FALSE,
  asp = 1,
  show = c("image", "contour"),
  image_args = list(useRaster = TRUE),
  contour_args = list()
)
}
\arguments{
\item{fn}{[\code{\link{soo_function}}] Function to plot.}

\item{lower}{[\code{numeric}] Lower bounds of x1 and x2.}

\item{upper}{[\code{numeric}] Upper bounds of x1 and x2.}

\item{n}{[\code{integer(1)}] Number of locations at which to sample the function.}

\item{main}{[\code{character(1)}] Main title of plot.}

\item{xlab}{[\code{character(1)}] Label of x (x1) axes.}

\item{ylab}{[\code{character(1)}] Label of y (x2) axes.}

\item{log}{[\code{boolean(1)}] If \code{TRUE}, the z axes is plotted on log scale.}

\item{rank}{[\code{boolean(1)}] If \code{TRUE}, instead of the y values, their ranks are drawn.}

\item{asp}{[\code{numeric(1)}] Aspect ratio of plot. Defaults to \code{1}.}

\item{show}{[\code{character}] A vector of parts to plot. Defaults to
\code{c("image", "contour")} and can be any subset.}

\item{image_args}{[\code{list}] List of further arguments passed to image().}

\item{contour_args}{[\code{list}] List of further arguments passed to contour().}

\item{...}{Ignored.}
}
\description{
Plot a test function in 2D.
}
\examples{
par(mfrow=c(2, 2))
fn <- generate_sphere_function(2)
plot(fn)
plot(fn, show="contour")
plot(fn, rank=TRUE)
plot(fn, log=TRUE)
}
\author{
Olaf Mersmann \email{olafm@p-value.net}
}
