% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radar.R
\name{radarPower}
\alias{radarPower}
\title{The radar equation}
\usage{
radarPower(P_t, r, area, G_t = 1, G_r = 1, wl = 1)
}
\arguments{
\item{P_t}{Power transmitted (from sender)}

\item{r}{Range of the target}

\item{area}{Effective cross-sectional area of the target}

\item{G_t}{Transmitter gain}

\item{G_r}{Receiver gain}

\item{wl}{Wavelength (use only with G_r and G_t)}
}
\value{
The received power
}
\description{
Calculates the power returned from an echolocation pulse
}
\examples{
radarPower(12, 20, 0.05)
radarPower(12, 20, 0.05, G_t=1.2, G_r=1.5, wl=0.045)

}
