\name{som.plot}
\alias{som.plot}
\title{
Function to plot hexagonal Kohonen maps 
}
\description{
The function plots hexagonal self-organising maps (SOMs), which have been created with Teuvo Kohonen's SOM_PAK software.

The plot shows an hexagonal lattice representing the codebook vectors of the SOM. Inside each
hexagon a pie chart is drawn, showing the relative percentage of pattern classes, mapped to this 
codebook vector. The size of each pie chart is adjusted according to the number of mapped patterns.

Several arguments allow customisation of size, scale and colouring of the plot.

The function needs two files of the SOM_PAK file set:
  \itemize{
  \item The output of \code{visual} provides
        the mapping of input patterns to the codebook vectors.
  \item The input file holding the mapped dataset with class information in the 
        last column.
  }
}

\usage{
som.plot(visfile, datfile, ...)
}

\arguments{
  \item{visfile}{
      Name of the output file of \code{visual}. \code{visual} is the
      tool of SOM_PAK which maps pattern to the codebook vectors of 
      a self-organising map.\\
      The function reads files in the format created by \code{visual}.
}
  \item{datfile}{
      Name of the SOM_PAK input file. This files contains all input patterns and 
      class information for each pattern. \code{som-plot} only uses the last
      colums of the file; i.e. the class information for each pattern.\\
      The function reads files in the format that is used by SOM_PAK.
}
  \item{\dots}{
      Many other arguments can be given to control the appearence of the plot:
      
      \sQuote{col}, default
      colours for the classes of the dataset. Possible values include:
      
      \sQuote{default value: NA.} Colours are generated by \code{rainbow()}
      
      \sQuote{vector} of colour definitions
      
      \sQuote{data frame} with name of a class in column 1 and 
            colour definitions in column 2.

       If the number of defined colours is smaller then the number of classes
       in the dataset, colours for the remaining classes are generated 
       by \code{rainbow}.
      

     \sQuote{onlyDefCols} default: \kbd{FALSE}; if TRUE, all undefined colours 
     are replaced by \kbd{white}

     \sQuote{edit.cols} default: \kbd{FALSE}; if TRUE, a dialog box opens
     and allows editing of all color definitions

     \sQuote{show.legend} default: \kbd{TRUE}; defines if colour legend is
     displayed

     \sQuote{legend.width} default: \kbd{4}; Width of legend

     \sQuote{turn} default: \kbd{FALSE}; swap X and Y axis 

     \sQuote{window.width} default: \kbd{NA}; width of the window         

     \sQuote{window.height} default: \kbd{NA}; height of the window         

     \sQuote{show.box} default: \kbd{TRUE}; show frame around the plot

     \sQuote{show.axis} default: \kbd{FALSE}; show x and Y axis

     \sQuote{scaleX} default: \kbd{NA}; scale factor for X axis (overwrites new.xdim argument)

     \sQuote{scaleY} default: \kbd{NA}; scale factor for Y axis (overwrites new.ydim argument)

     \sQuote{scale} default: \kbd{NA}; scale factor for X and Y axis (overwrites other scale argument)

     \sQuote{new.xdim} default: \kbd{NA}; scale X axis to specified number of 
     neurons          

     \sQuote{new.ydim} default: \kbd{NA}; scale Y axis to specified number of 
     neurons          

     \sQuote{show.counter.border} default: \kbd{0.98}         percentile as limit for the display of labels in the pie charts
}
}
%%\details{
%%
%%}
\value{
The function does not returns a value.
}
\references{
Schulz, B., Mauthe, T., Dominik, A., 2010.
Visualisation of Kohonen Maps using R.
University of Applied Sciences Giessen,
Website, [Online].
Available at: \url{http://www.life-science-it.org/pages/research/projectSomplot.html}
[Accessed 19 May 2011].
and
\url{http://www.bioconductor.org/packages/2.5/bioc/html/hexbin.html}
}
\author{
Benjamin Schulz, Andreas Dominik
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%%}
\examples{
som.plot(system.file("test.data/iris4som.out", package="somplot"), 
         system.file("test.data/iris4som.dat", package="somplot"))
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ High-Level Plots }
\keyword{ Graphics }
