\name{DT_augment}
\alias{DT_augment}
\docType{data}
\title{
DT_augment design example.
}
\description{
This dataset contains phenotpic data for one trait evaluated in the experimental design known as augmented design. This model allows to obtain BLUPs for genotypes that are unreplicated by dividing the field in blocks and replicating 'check genotypes' in the blocks and unreplicated genotypes randomly within the blocks. The presence of check genotypes (usually cultivars) allows the adjustment of unreplicated genotypes.

}
\usage{data("DT_augment")}
\format{
  The format is:
 chr "DT_augment"
}
\source{
This data was generated by a potato study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### AUGMENTED DESIGN EXAMPLE
####=========================================####
# data(DT_augment)
# DT <- DT_augment
# head(DT)
# ####=========================================####
# #### fit the mixed model and check summary
# ####=========================================####
# mix1 <- mmer(TSW ~ Check.Gen, 
#              random = ~ Block + Genotype:Check, 
#              data=DT)
# summary(mix1)
# blup <- mix1$U$`Genotype:Check`$TSW
# blup

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} }
