\name{cornHybrid}
\alias{cornHybrid}
\docType{data}
\title{
Corn crosses and markers
}
\description{
This dataset contains phenotpic data for plant height and grain yield for 100 out of 400 possible hybrids originated from 40 inbred lines belonging to 2 heterotic groups, 20 lines in each, 1600 rows exist for the 400 possible hybrids evaluated in 4 locations but only 100 crosses have phenotypic information.  The purpose of this data is to show how to predict the other 300 crosses.

The data contains 3 elements. The first is the phenotypic data and the parent information for each cross evaluated in the 4 locations. 1200 rows should have missing data but the 100 crosses performed were chosen to be able to estimate the GCA and SCA effects of everything.

The second element of the data set is the phenotypic data and other relevant information for the 40.

The third element is the genomic relationship matrix for the 40 inbred lines originated from 511 SNP markers and calculated using the A.mat function.

}
\usage{data("cornHybrid")}
\format{
  The format is:
 chr "cornHybrid"
}
\source{
This data was generated by a corn study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples using
#### command + shift + C |OR| control + shift + C
####=========================================####
data(cornHybrid)
####=========================================####
#### look at the list structure
####=========================================####
str(cornHybrid) 
####=========================================####
####=========================================####
#### breeding values with 3 variance components
#### hybrid prediction
####=========================================####
####=========================================####
data(cornHybrid)
hybrid2 <- cornHybrid$hybrid # extract cross data
A <- cornHybrid$K
y <- hybrid2$Yield
X1 <- model.matrix(~ Location, data = hybrid2);dim(X1)
Z1 <- model.matrix(~ GCA1 -1, data = hybrid2);dim(Z1)
Z2 <- model.matrix(~ GCA2 -1, data = hybrid2);dim(Z2)
Z3 <- model.matrix(~ SCA -1, data = hybrid2);dim(Z3)

colnames(Z1) <- levels(hybrid2$GCA1)
colnames(Z2) <- levels(hybrid2$GCA2)
colnames(Z3) <- levels(hybrid2$SCA)
####=========================================####
#### Realized IBS relationships for set of parents 1
####=========================================####
K1 <- A[levels(hybrid2$GCA1), levels(hybrid2$GCA1)]; dim(K1) 
####=========================================####
#### Realized IBS relationships for set of parents 2
####=========================================####
K2 <- A[levels(hybrid2$GCA2), levels(hybrid2$GCA2)]; dim(K2)
####=========================================####
#### Realized IBS relationships for cross 
#### (as the Kronecker product of K1 and K2)
####=========================================####
S <- kronecker(K1, K2) ; dim(S)   
rownames(S) <- colnames(S) <- levels(hybrid2$SCA)

ETA <- list(GCA1=list(Z=Z1, K=K1), 
            GCA2=list(Z=Z2, K=K2), 
            SCA=list(Z=Z3, K=S)
            )
#ans <- mmer(Y=y, X=X1, Z=ETA)
#ans$var.comp
#summary(ans)

####==========================================####
####==========================================####
#### using the 'mmer2' function would be fitted as
####==========================================####
####==========================================####

#data(cornHybrid)
#hybrid2 <- cornHybrid$hybrid # extract cross data
#A <- cornHybrid$K
#K1 <- A[levels(hybrid2$GCA1), levels(hybrid2$GCA1)]; dim(K1) 
#K2 <- A[levels(hybrid2$GCA2), levels(hybrid2$GCA2)]; dim(K2)
#S <- kronecker(K1, K2) ; dim(S)   
#rownames(S) <- colnames(S) <- levels(hybrid2$SCA)

#ans <- mmer2(Yield ~ Location, random = ~ g(GCA1) + g(GCA2) + g(SCA), 
#       G=list(GCA1=K1, GCA2=K2, SCA=S),data=hybrid2)
#summary(ans)

############################################
############################################
############################################
############################################
############################################
############################################

####==========================================####
####==========================================####
#### Example 2
#### covariance structure in interaction effects
####==========================================####
####==========================================####
# data(cornHybrid)
# hybrid2 <- cornHybrid$hybrid # extract cross data
# A <- cornHybrid$K # additive relationship matrix
# y <- hybrid2$Yield # response
# # subset additive relationship matrix
# K2 <- A[levels(hybrid2$GCA2), levels(hybrid2$GCA2)]; dim(K2)
# # create new variable
# hybrid2$GCA2.LOC <- paste(hybrid2$GCA2, hybrid2$Location, sep="-")
# L <- diag(4); 
# # variance covariance for G:E
# GA <- kronecker(L,K2); 
# colnames(GA) <- paste(colnames(K2),sort(rep(1:4,20)), sep="-")
# rownames(GA) <- colnames(GA); GA[1:4,1:4];
# 
# # fit the model
# ans <- mmer2(Yield ~ Location, random = ~ g(GCA2) + g(GCA2.LOC), 
#              G=list(GCA2=K2, GCA2.LOC=GA),data=hybrid2)
# summary(ans)

############################################
############################################
############################################
############################################
############################################
############################################

####==========================================####
####==========================================####
#### Example of multivariate model
####==========================================####
####==========================================####

# data(cornHybrid)
# hybrid2 <- cornHybrid$hybrid # extract cross data
# hybrid2 <- hybrid2[which(!is.na(hybrid2$Yield)),]
# names(hybrid2)[5:6] <- c("TY","PH")
# head(hybrid2)
# 
# A <- cornHybrid$K
# K1 <- A[levels(hybrid2$GCA1), levels(hybrid2$GCA1)]; dim(K1) 
# K2 <- A[levels(hybrid2$GCA2), levels(hybrid2$GCA2)]; dim(K2)
# S <- kronecker(K1, K2) ; dim(S)   
# rownames(S) <- colnames(S) <- levels(hybrid2$SCA)
# 
# ans <- mmer2(cbind(TY,PH) ~ Location, random = ~ g(GCA2) + g(SCA), 
#       G=list(GCA2=K2, SCA=S),data=hybrid2, MVM=TRUE)
# summary(ans)

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} and \code{\link{mmer2}}}
