% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffuseRadiation.R
\name{DiffuseRadiation}
\alias{DiffuseRadiation}
\title{Solar Diffuse Radiation on a Surface}
\usage{
DiffuseRadiation(DOY, Lat, Lon, SLon, DS, Elevation, Slope)
}
\arguments{
\item{DOY}{Day of year}

\item{Lat}{Latitude (in degrees)}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}

\item{Elevation}{Elevation of the site in meters}

\item{Slope}{Site slope in degrees}
}
\description{
This function returns solar diffuse dadiation (in W/m2) for a given day of year, location and topography.
}
\examples{

#Calculating atmospheric transmittance coefficient for two consecutive days on 45 degree
# latitude and 10 degree longitude and at 100 m altitude.

DOY <- seq(0, 2, .05)

Sdifopen <- DiffuseRadiation(DOY, Lat = 45, Lon=10, SLon=10, DS=0, Elevation = 100, Slope = 0)
#Note: only the difference between Lon and SLon matters not each value

plot(DOY, Sdifopen)

}
\keyword{Diffuse}
\keyword{Radiation}
