% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mukey-WCS.R
\name{mukey.wcs}
\alias{mukey.wcs}
\title{Get gNATSGO / gSSURGO Map Unit Key (\code{mukey}) grid from SoilWeb Web Coverage Service (WCS)}
\usage{
mukey.wcs(aoi, db = c("gnatsgo", "gssurgo"), res = 30, quiet = FALSE)
}
\arguments{
\item{aoi}{area of interest (AOI) defined using either a \code{Spatial*}, \code{RasterLayer}, \code{sf}, \code{sfc} or \code{bbox} object, or a \code{list}, see details}

\item{db}{name of the gridded map unit key grid to access, should be either 'gnatsgo' or 'gssurgo'}

\item{res}{grid resolution, units of meters. The native resolution of gNATSGO and gSSURGO (this WCS) is 30m.}

\item{quiet}{logical, passed to \code{download.file} to enable / suppress URL and progress bar for download.}
}
\value{
\code{raster} object containing indexed map unit keys and associated raster attribute table or a try-error if request fails
}
\description{
Download chunks of the gNATSGO or gSSURGO map unit key grid via bounding-box from the SoilWeb WCS.
}
\details{
\code{aoi} should be specified as one of: \code{Spatial*}, \code{RasterLayer}, \code{sf}, \code{sfc}, \code{bbox} object, or a \code{list} containing:

\describe{
\item{\code{aoi}}{bounding-box specified as (xmin, ymin, xmax, ymax) e.g. c(-114.16, 47.65, -114.08, 47.68)}
\item{\code{crs}}{coordinate reference system of BBOX, e.g. '+init=epsg:4326'}
}

The WCS query is parameterized using \code{raster::extent} derived from the above AOI specification, after conversion to the native CRS (EPSG:5070) of the gNATSGO / gSSURGO grid.

Databases available from this WCS can be queried using \code{WCS_details(wcs = 'mukey')}.
}
\note{
The gNATSGO grid includes raster soil survey map unit keys which are not in SDA.
}
\author{
D.E. Beaudette and A.G. Brown
}
