% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cosoilmoist_from_NASIS.R
\name{get_cosoilmoist_from_NASIS}
\alias{get_cosoilmoist_from_NASIS}
\title{Get the Component Soil Moisture Tables}
\usage{
get_cosoilmoist_from_NASIS(
  SS = TRUE,
  impute = TRUE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)
}
\arguments{
\item{SS}{fetch data from the currently loaded selected set in NASIS or from
the entire local database (default: \code{TRUE})}

\item{impute}{replace missing (i.e. \code{NULL}) values with \code{"Not_Populated"} for
categorical data, or the "RV" for numeric data or \code{201} cm if the "RV" is also
\code{NULL} (default: \code{TRUE})}

\item{stringsAsFactors}{logical: should character vectors be converted to
factors? This argument is passed to the \code{uncode()} function. It does not
convert those vectors that have set outside of \code{uncode()} (i.e. hard coded).
The 'factory-fresh' default is TRUE, but this can be changed by setting
options(\code{stringsAsFactors = FALSE})}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}
}
\value{
A data.frame.
}
\description{
Read and flatten the component soil moisture month tables from a local NASIS
Database.
}
\details{
The component soil moisture tables within NASIS house monthly data on
flooding, ponding, and soil moisture status. The soil moisture status is
used to specify the water table depth for components (e.g. \code{status ==
"Moist"}).
}
\examples{

\donttest{
if(local_NASIS_defined()) {
 # load cosoilmoist (e.g. water table data)
 test <- try(get_cosoilmoist_from_NASIS())

 # inspect
 if(!inherits(test, 'try-error')) {
   head(test)
 }
}
}
}
\seealso{
\link{fetchNASIS}, \link{get_cosoilmoist_from_NASISWebReport},
\link{get_cosoilmoist_from_SDA}, \code{get_comonth_from_SDA}
}
\author{
S.M. Roecker
}
\keyword{manip}
