% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_bulk_create.R
\name{db_bulk_create}
\alias{db_bulk_create}
\title{Create documents via the bulk API}
\usage{
db_bulk_create(cushion, dbname, doc, docid = NULL, how = "rows",
  as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{(character) Database name. Required.}

\item{doc}{A data.frame, list, or JSON as a character string. Required.}

\item{docid}{Document IDs, ignored for now, eventually, you can pass in a
list, or vector to be the ids for each document created. Has to be the same
length as the number of documents.}

\item{how}{(character) One of rows (default) or columns. If rows, each row
becomes a separate document; if columns, each column becomes a separate
document.}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
Either a list or json (depending on \code{as} parameter), with
each element an array of key:value pairs:
\itemize{
\item ok - whether creation was successful
\item id - the document id
\item rev - the revision id
}
}
\description{
Create documents via the bulk API
}
\details{
Note that row.names are dropped from data.frame inputs.
}
\examples{
\dontrun{
# initialize a CouchDB connection
(x <- Cushion$new())

# From a data.frame
if ("bulktest" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="bulktest"))
}
db_create(x, dbname="bulktest")
db_bulk_create(x, "bulktest", mtcars)

if ("bulktest2" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="bulktest2"))
}
db_create(x, dbname="bulktest2")
db_bulk_create(x, "bulktest2", iris)

# data.frame with 1 or more columns as neseted lists
mtcars$stuff <- list("hello_world")
mtcars$stuff2 <- list("hello_world","things")
if ("bulktest3" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="bulktest3"))
}
db_create(x, dbname="bulktest3")
db_bulk_create(x, "bulktest3", mtcars)

# From a json character string, or more likely, many json character strings
library("jsonlite")
strs <- as.character(parse_df(mtcars, "columns"))
if ("bulkfromchr" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="bulkfromchr"))
}
db_create(x, dbname="bulkfromchr")
db_bulk_create(x, "bulkfromchr", strs)

# From a list of lists
library("jsonlite")
lst <- parse_df(mtcars, tojson=FALSE)
if ("bulkfromchr" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="bulkfromchr"))
}
db_create(x, dbname="bulkfromchr")
db_bulk_create(x, "bulkfromchr", lst)

# iris dataset - by rows
if ("irisrows" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="irisrows"))
}
db_create(x, dbname="irisrows")
db_bulk_create(x, "irisrows", apply(iris, 1, as.list))

# iris dataset - by columns - doesn't quite work yet
# if ("iriscolumns" \%in\% db_list(x)) {
#   invisible(db_delete(x, dbname="iriscolumns"))
# }
# db_create(x, dbname="iriscolumns")
# db_bulk_create(x, "iriscolumns", parse_df(iris, "columns", tojson=FALSE), how="columns")
}
}
