% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominance.R
\name{dominates}
\alias{dominates}
\title{Dominance}
\usage{
dominates(powerRelation, e1, e2, strictly = FALSE, includeEmptySet = TRUE)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{e1, e2}{Elements in \code{powerRelation$elements}}

\item{strictly}{If \code{TRUE}, check if \code{p1} \emph{strictly} dominates \code{p2}}

\item{includeEmptySet}{If \code{TRUE}, check \eqn{\lbrace i \rbrace \succeq \lbrace j \rbrace}{\{i\} >= \{j\}} even if
empty set is not part of the power relation.}
}
\value{
Logical value \code{TRUE} if \code{e1} dominates \code{e2}, else \code{FALSE}.
}
\description{
Check if one element dominates the other.
}
\details{
\eqn{i}{i} is said to dominate \eqn{j}{j} if
\eqn{S \cup \lbrace i \rbrace \succeq S \cup \lbrace j \rbrace}{Sn\{i\} >= Sn\{j\}} for all
\eqn{S \in 2^{N \setminus \lbrace i,j \rbrace}}{S in 2^(N-\{i,j\})}.

\eqn{i}{i} \emph{strictly} dominates \eqn{j}{j} if there also exists an
\eqn{S \in 2^{N \setminus \lbrace i,j \rbrace}}{S in 2^(N-\{i,j\})} such that
\eqn{S \cup \lbrace i \rbrace \succ S \cup \lbrace j \rbrace}{Sn\{i\} > Sn\{j\}}.
}
\examples{
pr <- as.PowerRelation("12 > 1 > 2")

# TRUE
d1 <- dominates(pr, 1, 2)

# FALSE
d2 <- dominates(pr, 2, 1)

# TRUE (because it's not strict dominance)
d3 <- dominates(pr, 1, 1)

# FALSE
d4 <- dominates(pr, 1, 1, strictly = TRUE)

stopifnot(all(d1, !d2, d3, !d4))

}
