getBioMartData<-function(genes,verbose=FALSE) {
    mart = useMart("ensembl", dataset="hsapiens_gene_ensembl")
    listMarts(mart)[grep("ensembl",listMarts(mart)[,1]),]
    listDatasets(mart)[grep("hsapien",listDatasets(mart)[,1]),]

    geneattr<-c("hgnc_symbol","chromosome_name","start_position","end_position")

    if(verbose) cat("#Get Gene information from Mart\n")
    geneInfo<-getBM(geneattr,filters="hgnc_symbol",genes,mart)
    if(verbose) print( dim(geneInfo) )

    if(verbose) cat("#Only keep genes on chr 1:22, X, Y and MT\n")
    geneInfo<-subset(geneInfo,is.element(geneInfo$chromosome_name,c(1:22,"X","Y","MT")))
    if(verbose) print( dim(geneInfo) )

    if(verbose) cat("#Remove all duplicates\n")
    geneInfo<-subset(geneInfo,!duplicated(geneInfo$hgnc_symbol))
    names(geneInfo)<-c('gene','chr','start','end')
    if(verbose) print( dim(geneInfo) )
    
    return(geneInfo)
}
