% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_pars.R
\name{sk_pars_make}
\alias{sk_pars_make}
\title{Build a parameter list defining the 2d spatial Kronecker covariance model}
\usage{
sk_pars_make(pars = "gau")
}
\arguments{
\item{pars}{character vector of kernel name(s) or list of parameters (see details)}
}
\value{
parameter list containing sub-lists 'y', 'x', and scalars 'psill' and 'eps'
}
\description{
Constructs a nested list naming the expected covariance parameters for the supplied
correlation function names in \code{pars}. If \code{pars} is already such a list, the function
checks that parameter names and lengths are valid and returns a copy containing only the
expected parameters, properly named, with \code{NA}s assigned to any missing parameters.
}
\details{
\code{pars} should be a correlation function name accepted by \code{sk_kp} ('exp', 'gau','sph', or
'gex', 'mat'), or a vector or list of two of them in the order y, x.
}
\examples{
# pass a correlation function name to get 2d version with NAs for all parameters
sk_pars_make('mat')

# pass a vector or list of correlation function names in order y, x (or else specify)
sk_pars_make(c('gau', 'mat'))
sk_pars_make(list(x='gau', y='mat'))

# if the the x definition is missing it is copied from y, and vice versa
sk_pars_make(list(k='exp', kp=c(rho=1)))

# when unnamed, kernel range and shape parameters are assigned expected names
sk_pars_make(list(psill=1, x=list(k='mat', kp=c(1,2))))

# incorrectly named parameters raise errors
\donttest{
sk_pars_make(list(psill=1, x=list(k='exp', kp=c(foo=1))))
}

# complete parameter definition lists are returned unchanged
k_list = list(k='exp', kp=c(rho=1))
pars = list(y=k_list, x=k_list, eps=0, psill=1)
identical(pars, sk_pars_make(pars))

}
\seealso{
sk_corr

Other parameter managers: 
\code{\link{sk_bds}()},
\code{\link{sk_fit}()},
\code{\link{sk_kp}()},
\code{\link{sk_pars_update}()},
\code{\link{sk_pars}()},
\code{\link{sk_to_string}()}
}
\concept{parameter managers}
\keyword{internal}
