% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_export.R
\name{sk_coords}
\alias{sk_coords}
\title{Return coordinates of a grid of points in column-vectorized order}
\usage{
sk_coords(g, out = "matrix", corner = FALSE, na_omit = FALSE, quiet = FALSE)
}
\arguments{
\item{g}{any object accepted by \code{sk}}

\item{out}{character indicating return value type, either 'list', 'matrix', or 'sf'}

\item{corner}{logical, indicates to return only the four corner points}

\item{na_omit}{logical, indicates to return only locations of observed points}

\item{quiet}{logical, suppresses console output}
}
\value{
a matrix, list, or sf point collection in column vectorized order
}
\description{
Expands a set of y and x grid line numbers in the column-vectorized order returned
by \code{sk}. This is similar to \code{base::expand.grid} but with the first dimension (y)
descending instead of ascending.
}
\details{
\code{out='sf'} returns an \code{sf} simple features object containing points in the same order,
with data (if any) copied from \code{g[['gval']]} into column 'gval'. Note that \code{length(g)}
points are created, which can be slow for large grids.

If \code{na_omit} is \code{TRUE} the function omits points with \code{NA} data (in \code{gval}) and only
returns the coordinates for observations. This argument is ignored when \code{corners=TRUE}
(which always returns the four corner points) or when the grid contains no observations
(all points returned).
}
\examples{
gdim = c(5,3)
g_complete = sk(gdim=gdim, gres=c(0.5, 0.7), gval=seq(prod(gdim)))
sk_coords(g_complete)
sk_coords(g_complete, out='list')

# missing data example
idx_obs =  sort(sample.int(length(g_complete), 5))
g = sk(gdim=gdim, gres=c(0.5, 0.7))
g[idx_obs] = g_complete[idx_obs]
all.equal(sk_coords(g, na_omit=TRUE), sk_coords(g_complete)[idx_obs,])

# corner points
sk_coords(g, corner=TRUE)
sk_coords(g, corner=TRUE, out='list')

# repeat with multi-layer example
g_multi = sk(utils::modifyList(g, list(gval = cbind(g[], 2*g[]))))
all.equal(sk_coords(g_multi, na_omit=TRUE), sk_coords(g_complete)[idx_obs,])
sk_coords(g_multi, corner=TRUE)

# sf output type
if( requireNamespace('sf') ) {

# gather all points but don't copy data
sf_coords_all = sk_coords(sk(g, vals=FALSE), out='sf')

# extract non-NA data
sf_coords = sk_coords(g, out='sf', na_omit=TRUE)

# plot everything together
plot(g, reset=FALSE)
plot(sf_coords_all, add=TRUE)
plot(sf_coords, pch=16, cex=2, add=TRUE)

}

}
\seealso{
sk sk_snap base::expand.grid

Other exporting functions: 
\code{\link{sk_export}()}
}
\concept{exporting functions}
