% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{plot.smAPC}
\alias{plot.smAPC}
\title{Presents demographic data as a heatmap}
\usage{
\method{plot}{smAPC}(x, component = c("all", "surface", "period", "cohort",
  "residuals", "original"), labs = c("Age", "Time"),
  color.palette = c("default", "special"), main = "", ...)
}
\arguments{
\item{x}{Result of smoothing (object of class \code{smAPC}).}

\item{component}{"smooth", "period", "cohort", "residuals" or "original".}

\item{labs}{Vector of labels for X and Y axes.}

\item{color.palette}{Character string \code{"default"} or \code{"special"} or a function accepting one argument and returning a color palette
(for example \code{\link[grDevices]{rainbow}}).}

\item{main}{Title for the plot.}

\item{...}{Other parameters. They are currently ignored.}
}
\description{
Presents demographic data as a heatmap
}
\examples{
\donttest{

library(demography)
m <- log(fr.mort$rate$female[1:30, 150:160])
sm <- autoSmoothAPC(m)

plot(sm)
plot(sm, "surface")
plot(sm, "cohort")
plot(sm, "period")
plot(sm, "residuals")
plot(sm, "original", main = "Original data")

}
}
\author{
Alexander Dokumentov
}

