% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{plot3d.matrix}
\alias{plot3d.matrix}
\title{Presents matrix as a 3D surface}
\usage{
\method{plot3d}{matrix}(x, labs = c("X", "Y", "Z"),
  color.palette = c("default", "special"), ...)
}
\arguments{
\item{x}{Matrix to plot.}

\item{labs}{Vector of labels for X, Y and Z axes.}

\item{color.palette}{Character string \code{"default"} or \code{"special"} or a function accepting one argument and returning a color palette
(for example \code{\link[grDevices]{rainbow}}).}

\item{...}{Other parameters. They are currently ignored.}
}
\description{
Presents matrix as a 3D surface
}
\examples{
\donttest{

plot3d(matrix(rnorm(100),10,10))
plot3d(matrix(1:100,10,10), c("Dimension 1", "Dimension 2", "Value"))

library(demography)
m <- log(fr.mort$rate$female[1:30, 150:160])
plot3d(m)
plot3d(m, color.palette = "special")
plot3d(m, color.palette = rainbow)
}
}
\author{
Alexander Dokumentov
}

