% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLoggedValues.R
\name{getLoggedValues}
\alias{getLoggedValues}
\title{Extract logged values of a function wrapped by a logging wrapper.}
\usage{
getLoggedValues(fn, compact = FALSE)
}
\arguments{
\item{fn}{[\code{wrapped_smoof_function}]\cr
Wrapped smoof function.}

\item{compact}{[\code{logical(1)}]\cr
Wrap all logged values in a single data frame? Default is \code{FALSE}.}
}
\value{
[\code{list} || \code{data.frame}]
  If \code{compact} is \code{TRUE}, a single data frame. Otherwise the function
  returns a list containing the following values:
  \describe{
    \item{pars}{Data frame of parameter values, i.e., x-values or the empty
    data frame if x-values were not logged.}
    \item{obj.vals}{Numeric vector of objective vals in the single-objective
    case respectively a matrix of objective vals for multi-objective functions.}
  }
}
\description{
Extract logged values of a function wrapped by a logging wrapper.
}
\seealso{
\code{\link{addLoggingWrapper}}
}

