% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.smnet.R
\name{plot.smnet}
\alias{plot.smnet}
\title{Visualise a Fitted Stream Network Model}
\usage{
\method{plot}{smnet}(
  x,
  type = "covariates",
  se = FALSE,
  res = FALSE,
  weight = NULL,
  sites = FALSE,
  sites.col = NULL,
  sites.cex = 1,
  network.col = NULL,
  shadow = 0,
  key = TRUE,
  legend.text = NULL,
  legend.range = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \bold{smnet}.}

\item{type}{Character string identifying the type of plot to be produced.
The default, \code{type = 'covariates'}, produces plots of all linear and smooth
components (the latter corresponding to each appearance of \code{m()}
in the model formula).  \code{type = 'full'} plots the stream network fitted mean
using the full set of spatial points contained in the associated \code{SSN}
object.   \code{type = 'segments'} plots the stream network fitted mean using a set
of connected line segments to represent the spatial network, this can be
faster for large networks than \code{type = 'full'}.}

\item{se}{Logical.  When \code{TRUE} and \code{type = 'covariates'}, standard errors
are shown on plots of linear and smooth terms.  When \code{type = 'segment'} or
\code{type = 'full'} spatial standard errors are plotted.}

\item{res}{Logical.  When \code{TRUE}, partial residuals are shown on plots of linear
and smooth component.  Ignored when  \code{type = 'full'} or \code{type = 'segments'}.}

\item{weight}{Positive real number that scales stream segment widths (as determined using
Shreve order) to indicate relative size of stream segments.  Ignored when
\code{type = 'covariate'}.  Currently only \code{'autoShreve'} is supported, defaults to
\code{NULL} in which all streams segments are plotted with lines with identical widths.}

\item{sites}{Logical indicating whether locations of observation sites should be added to
spatial plots.  Ignored when \code{type = 'covariate'} and defaults to \code{FALSE}.}

\item{sites.col}{Single colour to plot observation locations.  If not provided, points will
be coloured according to the default legend and average observation at each location.}

\item{sites.cex}{Expansion factor for the size of plotted observation points.}

\item{network.col}{Single colour to represent all stream segments. By default, network is
coloured according to fitted values from model. Ignored when \code{type = 'covariate'}.}

\item{shadow}{Positive scalar that adds a black outline to spatial stream segment plots,
useful if the colour scale has many light colours.  Ignored when \code{type = 'covariate'}
and defaults to 0 (no shadow is drawn).}

\item{key}{Logical.  Plots a colour legend for network plots.  Ignored when
\code{type = 'covariates'}.}

\item{legend.text}{Character annotation to add to color scale.  Ignored if
\code{key = FALSE} or \code{type = 'covariates'}.}

\item{legend.range}{Range of values represented by the color scale.  Ignored if
\code{key = FALSE} or \code{type = 'covariates'}.}

\item{...}{Other arguments passed to \code{plot()}.}
}
\description{
Plot linear, univariate and bivariate smooth effects and network
smooth terms that resulting from a call to \code{smnet()}.
}
\author{
Alastair Rushworth
}
