% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/splines1d.R
\name{cardinalBasis_lagrange}
\alias{cardinalBasis_lagrange}
\title{Cardinal Basis for Lagrange (broken line) interpolation}
\usage{
cardinalBasis_lagrange(x, xout)
}
\arguments{
\item{x}{Numeric vector of design points.}

\item{xout}{Numeric vector giving new points.}
}
\value{
A list with the following elements

\item{x}{

Numeric vector of abscissas at which the basis is evaluated. This
is a copy of \code{xout}.

}
\item{CB}{

Matrix of the Cardinal Basis function values.

}
}
\description{
Cardinal Basis for Lagrange interpolation.
}
\details{
This is a simple and raw interface to \code{alterp} Fortran
subroutine. It is a wrapper for \code{\link{cardinalBasis_ceschino}}
function with \code{cubic = FALSE} and \code{deriv = 0L}.
}
\note{
This function does not allow extrapolation, so an error will
result when \code{xout} contains element outside of the range of
\code{x}. The function used here is a spline of degree 1 (order 2).
}
\examples{
set.seed(123)
n <- 16; nout <- 300
x <- sort(runif(n))

##' ## let 'xout' contain n + nout points including nodes
xout <- sort(c(x, runif(nout, min = x[1], max = x[n])))
res  <- cardinalBasis_lagrange(x, xout = xout)

matplot(res$x, res$CB, type = "n", main = "Cardinal Basis")
abline(v = x, h = 1.0, col = "gray")
points(x = x, y = rep(0, n), pch = 21, col = "black", lwd = 2, bg = "white")
matlines(res$x, res$CB, type = "l")

## Lebesgue's function is constant = 1.0: check it
L <- apply(res$CB, 1, function(x) sum(abs(x)))
range(L)
}

