% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GridData.R
\name{boundary_Grid}
\alias{boundary_Grid}
\title{Find boundary points in a \code{Grid} object}
\usage{
boundary_Grid(x, type = c("data.frame", "array", "index"))
}
\arguments{
\item{x}{An object with class \code{"Grid"}.}

\item{type}{The wanted type of result.}
}
\value{
An object describing the boundary points. See
\bold{Details}.
}
\description{
Find boundary points in a \code{Grid} object.
}
\details{
When \code{type} is \code{"data.frame"}, the returned object is a
data frame containing only the boundary points. When \code{type}
is \code{"array"} the result is a logical array with its elements
in correspondence with the \code{index} slot of the
object. Finally, when \code{type} is \code{"index"}, the result is
an integer vector giving the indices of the boundary points in the
order of the nodes defined by the object. This order is the one
used by the \code{as.data.frame} coercion.
}
\note{
Remind that when using the \code{plot} method for a
\code{Grid} object, some nodes are generally hidden because
several points have the same projection when they are shown in a
two-dimensional scatterplot.

When one or more of the levels has length \eqn{\leq 2}{<= 2}, all
points of the grid are boundary points!
}
\examples{
## define a Grid object
myGD <- Grid(nlevels = c(3, 4))
bd <- boundary_Grid(myGD, type = "index")

## use a different color for boundary points
cols <- rep("black", length(myGD))
cols[bd] <- "red"
plot(myGD, col = cols, pch = 16, cex = 2, main = "Boundary points")

## repeat this after a generalised transposition
myGD2 <- aperm(myGD, perm = c(2, 1))
bd2 <- boundary_Grid(myGD2, type = "index")
cols2 <- rep("black", length(myGD2))
cols2[bd2] <- "red"
plot(myGD2, col = cols2, pch = 16, cex = 2, main = "Boundary points")

## 3-dimensional
myGD3 <- Grid(nlevels = c("x" = 3, "y"= 4, "z" = 6))
bd3 <- boundary_Grid(myGD3, type = "index")
cols3 <- rep("black", length(myGD3))
cols3[bd3] <- "red"
plot(myGD3, jitter = TRUE, col = cols3, pch = 16, cex = 2, main = "Boundary points")
}

