% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uls.test.R
\name{uls.test}
\alias{uls.test}
\title{Upper Level Set Spatial Scan Test}
\usage{
uls.test(
  coords,
  cases,
  pop,
  w,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.1,
  ubpop = 0.5,
  longlat = FALSE,
  cl = NULL,
  type = "poisson",
  check.unique = FALSE
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{check.unique}{A logical value indicating whether a
check for unique values should be determined.  The
default is \code{FALSE}.  This is unlikely to make a
practical different for most real data sets.}
}
\value{
Returns a list of length two of class scan. The
  first element (clusters) is a list containing the
  significant, non-ovlappering clusters, and has the the
  following components: \item{locids}{The location ids of
  regions in a significant cluster.} \item{pop}{The total
  population in the cluser window.} \item{cases}{The
  observed number of cases in the cluster window.}
  \item{expected}{The expected number of cases in the
  cluster window.} \item{smr}{Standarized mortaility
  ratio (observed/expected) in the cluster window.}
  \item{rr}{Relative risk in the cluster window.}
  \item{loglikrat}{The loglikelihood ratio for the
  cluster window (i.e., the log of the test statistic).}
  \item{pvalue}{The pvalue of the test statistic
  associated with the cluster window.} The second element
  of the list is the centroid coordinates.  This is
  needed for plotting purposes.
}
\description{
\code{uls.test} performs the Upper Level Set (ULS)
spatial scan test of Patil and Taillie (2004).  The test
is performed using the spatial scan test based on a fixed
number of cases.  The windows are based on the Upper
Level Sets proposed by Patil and Taillie (2004).  The
clusters returned are non-overlapping, ordered from most
significant to least significant.  The first cluster is
the most likely to be a cluster.  If no significant
clusters are found, then the most likely cluster is
returned (along with a warning).
}
\details{
The ULS method has a special (and time consuming)
construction when the observed rates aren't unique.  This
is unlikely to arise for real data, except with observed
rates of 0, which are of little interest.  The method can
take substantially if this is considered.
}
\examples{
data(nydf)
data(nyw)
coords <- with(nydf, cbind(longitude, latitude))
out <- uls.test(
  coords = coords, cases = floor(nydf$cases),
  pop = nydf$pop, w = nyw,
  alpha = 0.05, longlat = TRUE,
  nsim = 9, ubpop = 0.5
)
# better plotting
if (require("sf", quietly = TRUE)) {
   data(nysf)
   plot(st_geometry(nysf), col = color.clusters(out))
}
}
\references{
Patil, G.P. & Taillie, C. Upper level set
  scan statistic for detecting arbitrarily shaped
  hotspots. Environmental and Ecological Statistics
  (2004) 11(2):183-197.
  <doi:10.1023/B:EEST.0000027208.48919.7e>
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.stat}}, \code{\link{scan.test}}
}
\author{
Joshua French
}
