% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_prune.R
\name{sig_prune}
\alias{sig_prune}
\title{Prune significant, non-overlapping zones}
\usage{
sig_prune(tobs, zones, pvalue, alpha)
}
\arguments{
\item{tobs}{The vector of observed test statistics for each zone}

\item{zones}{A list of zones}

\item{pvalue}{The p-value associated with each test statistic}

\item{alpha}{The significance level of the test.}
}
\value{
A list with the significant, ordered,
non-overlapping \code{tobs}, \code{zones}, \code{pvalue}.,
and \code{idx} (a vector with the relevant indices of
the original zones).
}
\description{
\code{sig_prune} returns the significant
zones ordered from most significant to least significant (assuming the zones are already in order)
}
\examples{
tobs <- c(3, 2, 1)
zones <- list(1:2, 3:4, 5:6)
pvalue <- c(0.001, 0.05, 0.15)
sig_prune(tobs, zones, pvalue, alpha = 0.05)
}
\keyword{internal}
