% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lget.R
\name{lget}
\alias{lget}
\alias{lgetElement}
\alias{sget}
\alias{sgetElement}
\title{Apply getElement over a list}
\usage{
lget(X, name)

lgetElement(X, name)

sget(X, name, simplify = TRUE, USE.NAMES = TRUE)

sgetElement(X, name, simplify = TRUE, USE.NAMES = TRUE)
}
\arguments{
\item{X}{A list.}

\item{name}{
    A literal character string or a \link[base]{name} (possibly \link[base]{backtick}
    quoted).  For extraction, this is normally (see under
    \sQuote{Environments}) partially matched to the \code{\link[base]{names}}
    of the object.
  }

\item{simplify}{logical or character string; should the result be
    simplified to a vector, matrix or higher dimensional array if
    possible?  For \code{sapply} it must be named and not abbreviated.
    The default value, \code{TRUE}, returns a vector or matrix if appropriate,
    whereas if \code{simplify = "array"} the result may be an
    \code{\link[base]{array}} of \dQuote{rank}
    (\eqn{=}\code{length(dim(.))}) one higher than the result
    of \code{FUN(X[[i]])}.}

\item{USE.NAMES}{logical; if \code{TRUE} and if \code{X} is character,
    use \code{X} as \code{\link[base]{names}} for the result unless it had names
    already.  Since this argument follows \code{\dots} its name cannot
    be abbreviated.}
}
\value{
A list (\code{lget}) or vector (\code{sget})
of the same length as \code{X} with the
\code{name} parts of each element of \code{X}.
}
\description{
\code{lget} or \code{lgetElement} applies
\code{\link[base]{getElement}} to a
list using \code{\link[base]{lapply}}. \code{sget} and
\code{sgetElement} do the same thing with
\code{\link[base]{sapply}}
}
\examples{
e1 = list(x = rnorm(5),
          y = letters[c(1:2, 2:1, 3)],
          z = c(TRUE, TRUE, FALSE, TRUE, TRUE)
)
e2 = list(x = rnorm(5),
          y = letters[c(1:4, 1)],
          z = c(FALSE, TRUE, FALSE, TRUE, FALSE))
X = list(e1, e2)
lget(X, name = "x")
sget(X, name = "y")
}
