% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uls.test.R
\name{uls.test}
\alias{uls.test}
\title{Upper Level Set Spatial Scan Test}
\usage{
uls.test(coords, cases, pop, w, ex = sum(cases)/sum(pop) * pop, nsim = 499,
  alpha = 0.1, nreport = nsim + 1, ubpop = 0.5, lonlat = FALSE,
  parallel = TRUE)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid coordinates for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each region.}

\item{w}{A binary spatial adjacency matrix.}

\item{ex}{The expected number of cases for each region.  The default is calculated under the constant risk hypothesis.}

\item{nsim}{The number of simulations from which to compute the p-value.}

\item{alpha}{The significance level to determine whether a cluster is signficant.  Default is \code{0.10}.}

\item{nreport}{The frequency with which to report simulation progress.  The default is \code{nsim+ 1}, meaning no progress will be displayed.}

\item{ubpop}{The upperbound of the proportion of the total population to consider for a cluster.}

\item{lonlat}{The default is \code{FALSE}, which specifies that Euclidean distance should be used.If \code{lonlat} is \code{TRUE}, then the great circle distance is used to calculate the intercentroid distance.}

\item{parallel}{A logical indicating whether the test should be parallelized using the \code{parallel::mclapply function}.  Default is \code{TRUE}.  If \code{TRUE}, no progress will be reported.}
}
\value{
Returns a list of length two of class scan. The first element (clusters) is a list containing the significant, non-ovlappering clusters, and has the the following components: 
\item{locids}{The location ids of regions in a significant cluster.}
\item{pop}{The total population in the cluser window.}
\item{cases}{The observed number of cases in the cluster window.}
\item{expected}{The expected number of cases in the cluster window.}
\item{smr}{Standarized mortaility ratio (observed/expected) in the cluster window.}
\item{rr}{Relative risk in the cluster window.}
\item{loglikrat}{The loglikelihood ratio for the cluster window (i.e., the log of the test statistic).}
\item{pvalue}{The pvalue of the test statistic associated with the cluster window.}
The second element of the list is the centroid coordinates.  This is needed for plotting purposes.
}
\description{
\code{uls.test} performs the Upper Level Set (ULS) spatial scan test of Patil and Taillie (2004).
}
\details{
The test is performed using the spatial scan test based on the Poisson test statistic and a fixed number of cases.  The windows are based on the Upper Level Sets proposed by Patil and Taillie (2004).  The clusters returned are non-overlapping, ordered from most significant to least significant.  The first cluster is the most likely to be a cluster.  If no significant clusters are found, then the most likely cluster is returned (along with a warning).
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
out = uls.test(coords = coords, cases = floor(nydf$cases), 
                  pop = nydf$pop, w = nyw, 
                  alpha = 0.12, lonlat = TRUE,
                  nsim = 10, ubpop = 0.1)
## plot output for new york state
# specify desired argument values
mapargs = list(database = "state", region = "new york", 
xlim = range(out$coords[,1]), ylim = range(out$coords[,2]))
# needed for "state" database (unless you execute library(maps))
data(stateMapEnv, package = "maps") 
plot(out, usemap = TRUE, mapargs = mapargs)

data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.  Kulldorff, M. (1997) A spatial scan statistic. Communications in Statistics -- Theory and Methods 26, 1481-1496.
}
\seealso{
\code{\link{scan.stat}}, \code{\link{plot.scan}}, 
\code{\link{scan.test}}, \code{\link{flex.test}}, 
\code{\link{dmst.test}}, \code{\link{bn.test}}
}
\author{
Joshua French
}
