% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm2.R
\name{sm2_encrypt_c1c2c3}
\alias{sm2_encrypt_c1c2c3}
\alias{sm2_decrypt_c1c2c3}
\title{SM2 Encrypt/Decrypt - c1c2c3}
\usage{
sm2_encrypt_c1c2c3(data, public_key)

sm2_decrypt_c1c2c3(data, private_key)
}
\arguments{
\item{data}{data to be encrypted or decrypted, must be a raw vector}

\item{public_key}{a public key represented as a hexadecimal string}

\item{private_key}{a private key represented as a hexadecimal string}
}
\value{
\describe{
  \item{\link{sm2_encrypt_c1c2c3}}{returns a raw vector of the cipher text in the order of c1c2c3}
  \item{\link{sm2_decrypt_c1c2c3}}{returns a raw vector of the plain text}
}
}
\description{
The result of SM2 asymmetric encryption consists of three parts: C1, C2, and C3.
Among them, C1 is the elliptic curve point calculated based on a generated
random number, C2 is the ciphertext data, and C3 is the digest value of SM3.
Regarding the two modes of C1C2C3 and C1C3C2, the original Chinese national
standard specified the order of C1C2C3, while the new standard follows the
order of C1C3C2. These two different order modes are mainly designed to
facilitate the parsing and processing of SM2 encryption results across
different systems and environments.
}
\examples{
## encrypt and decrypt as c1c2c3
keypair <- sm2_gen_keypair()
private_key <- keypair$private_key
public_key <- keypair$public_key
data <- 'abc' |> charToRaw()
enc <- sm2_encrypt_c1c2c3(data, public_key)
enc
dec <- sm2_decrypt_c1c2c3(enc, private_key)
dec
}
