% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movres.R
\name{rMovRes}
\alias{rMovRes}
\title{Sampling from a Moving-Resting Process with Embedded Brownian Motion}
\usage{
rMovRes(time, lamM, lamR, sigma, s0, dim = 2)
}
\arguments{
\item{time}{time points at which observations are to be simulated}

\item{lamM}{rate parameter of the exponential duration while moving}

\item{lamR}{rate parameter of the exponential duration while resting}

\item{sigma}{volatility parameter of the Brownian motion while moving}

\item{s0}{the state at time 0, must be one of "m" or "r", for moving and
resting, respectively}

\item{dim}{(integer) dimension of the Brownian motion}
}
\value{
A \code{data.frame} whose first column is the time points and whose
other columns are coordinates of the locations.
}
\description{
A moving-resting process consists of two states: moving and resting.
The transition between the two states is modeled by an alternating
renewal process, with expenentially distributed duration. An animal
stays at the same location while resting, and moves according to a
Brownian motion while moving.
}
\examples{
tgrid <- seq(0, 10, length=1001)
## make it irregularly spaced
tgrid <- sort(sample(tgrid, 800))
dat <- rMovRes(tgrid, 1, 1, 1, "m")
plot(dat[,1], dat[,2], xlab="t", ylab="X(t)", type='l')

}
\references{
Yan, J., Chen, Y., Lawrence-Apfel, K., Ortega, I. M., Pozdnyakoc, V.,
Williams, S., and Meyer, T. (2014) A moving-resting process with an
embedded Brownian motion for animal movements.
Population Ecology. 56(2): 401--415.
}

