%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:04.
% Do NOT modify this file, instead modify the source (sma/R/Rarray.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.ma}

\alias{stat.ma}
\alias{ma.func}
\alias{norm.l.func}
\alias{norm.pin.func}
\alias{norm.scale.func}

\title{Calculation of log Intensity Ratios and Average log Intensities}

\description{
Computes the log intensity ratio \eqn{M = log_2 (R/G)} and the mean log
intensity \eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G
represent the fluorescence
intensities in the red and green channels, respectively. Logarithms base
2 are used instead of natural or decimal logarithms as intensities are
typically integers between 1 and \eqn{2^{16}}. The log intensity
ratios M are normalized using one of the five available methods. 
}

\usage{
stat.ma(RG, layout, norm="p", pout=F, ...)
}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid  
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}
  
  \item{pout}{if TRUE, an M vs. A plot will be produced.  Otherwise,
  a matrix of log intensity ratios and average log intensities is
  returned. } 
  
  \item{\dots}{other parameters used in \code{\link{ma.func}}. }
}

\value{
  List containing the following components:
  
  \item{M}{Matrix of log expression ratios \eqn{M = log_2 (R/G)}}
  \item{A}{Matrix of average log intensities \eqn{A = log_2
      \sqrt{RG}}{A = log_2(R*G)/2}}
  For the matrix in each of the components, rows correspond to genes
  and columns correspond to different hybridizations, that is different slides. 
}

\references{S. Dudoit, Y. H. Yang, M. J. Callow, and T. P. Speed. Statistical
methods for identifying differentially expressed genes in replicated
cDNA microarray experiments (Statistics, UC Berkeley, Tech Report \# 578).  }

\note{\code{\link{ma.func}}, \code{\link{norm.l.func}},
  \code{\link{norm.scale.func}} and \code{\link{norm.pin.func}} are called by \code{\link{stat.ma}} and are not typically used on their own.}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Natalie Roberts, \email{nroberts@wehi.edu.au}
}

\seealso{\code{\link{ma.func}}, \code{\link{norm.l.func}},
  \code{\link{norm.pin.func}}, \code{\link{norm.scale.func}}, \code{\link{plot.mva}}, \code{\link{lowess}}.}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
mouse.lratio <- stat.ma(mouse.data, mouse.setup)
}

\keyword{microarray, log ratio.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
