% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\name{cov_spectralproj}
\alias{cov_spectralproj}
\title{Data-driven spectral density estimation}
\usage{
cov_spectralproj(epsilon, model_selec = -1,
 model_max = min(100,length(epsilon)/2), plot = FALSE)
}
\arguments{
\item{epsilon}{an univariate process.}

\item{model_selec}{the dimension of the method. If \code{model_selec = -1}, the method works automatically and take a dimension between 1 and \code{model_max}.}

\item{model_max}{the maximal dimension. By default, it is equal to the minimum between 100 and the length of the process divided by 2.}

\item{plot}{logical. By default, \code{plot = FALSE}. If \code{plot = TRUE}, plot the spectral density estimator of the process.}
}
\value{
The function returns the estimated autocovariances of the process, that is the Fourier coefficients
 of the spectral density estimates, and the dimension chosen by the algorithm.
 \item{model_selec}{the dimension selected.}
 \item{cov_st}{the estimated autocovariances.}
}
\description{
Computes a data-driven histogram estimator of the spectral density of a process and compute its Fourier coefficients,
 that is the associated autocovariances. For a dimension \eqn{d}, the estimator of the spectral density is an histogram on a regular basis of
 size \eqn{d}. Then we use a penalized criterion in order to choose the dimension which balance the bias and the variance. The penalty
 is of the form \eqn{c*d/n}, where \eqn{c} is the constant and \eqn{n} the sample size. The dimension and the constant of the penalty are
 chosen with the slope heuristic method, with the dimension jump algorithm (from package "\code{\link[capushe:capushe]{capushe}}").
}
\examples{
x = arima.sim(list(ar=c(0.2), ma=c(0.3,0.05)), n=100)
cov_spectralproj(x, model_selec = -1)
}
\references{
J.P. Baudry, C. Maugis B. and Michel (2012). Slope heuristics: overview and implementation. \emph{Statistics and Computing}, 22(2), 455–470.

 E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.

 F. Comte (2001). Adaptive estimation of the spectrum of a stationary Gaussian sequence. \emph{Bernoulli}, 7(2), 267-298.
}
\seealso{
The R package \code{\link[capushe]{capushe}}.

Slope heuristic algorithm \code{\link[capushe]{DDSE}}.

Dimension jump algorithm \code{\link[capushe]{Djump}}.
}
