% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{schedule_sampling}
\alias{schedule_sampling}
\title{Define sampling events for a given set of populations}
\usage{
schedule_sampling(model, times, ..., locations = NULL, strict = FALSE)
}
\arguments{
\item{model}{Object of the class \code{slendr_model}}

\item{times}{Integer vector of times (in model time units) at which to
schedule remembering of individuals in the tree-sequence}

\item{...}{Lists of two elements (\code{slendr_pop} population object-<number
of individuals to sample), representing from which populations should how
many individuals be remembered at times given by \code{times}}

\item{locations}{List of vector pairs, defining two-dimensional coordinates
of locations at which the closest number of individuals from given
populations should be sampled. If \code{NULL} (the default), individuals
will be sampled randomly throughout their spatial boundary.}

\item{strict}{Should any occurence of a population not being present at a
given time result in an error? Default is \code{FALSE}, meaning that
invalid sampling times for any populations will be quietly ignored.}
}
\value{
Data frame with three columns: time of sampling, population to sample
from, how many individuals to sample
}
\description{
Schedule sampling events at specified times and, optionally, a given set of
locations on a landscape
}
\details{
If both times and locations are given, the the sampling will be scheduled on
each specified location in each given time-point. Note that for the
time-being, in the interest of simplicity, no sanity checks are performed on
the locations given except the restriction that the sampling points must fall
within the bounding box around the simulated world map. Other than that,
slendr will simply instruct its SLiM backend script to sample individuals as
close to the sampling points given as possible, regardless of whether those
points lie within a population spatial boundary at that particular moment of
time.
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
# load an example model with an already simulated tree sequence
path <- system.file("extdata/models/introgression", package = "slendr")
model <- read_model(path)

# afr and eur objects would normally be created before slendr model compilation,
# but here we take them out of the model object already compiled for this
# example (in a standard slendr simulation pipeline, this wouldn't be necessary)
afr <- model$populations[["AFR"]]
eur <- model$populations[["EUR"]]

# schedule the recording of 10 African and 100 European individuals from a
# given model at 20 ky, 10 ky, 5ky ago and at present-day (time 0)
schedule <- schedule_sampling(
  model, times = c(20000, 10000, 5000, 0),
  list(afr, 10), list(eur, 100)
)

# the result of `schedule_sampling` is a simple data frame (note that the locations
# of sampling locations have `NA` values because the model is non-spatial)
schedule
}
