% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weekly_matchups.R
\name{get_weekly_matchups}
\alias{get_weekly_matchups}
\title{Gather All Weekly Matchup Data Available for League}
\usage{
get_weekly_matchups(league_id, type = "all")
}
\arguments{
\item{league_id}{League ID generated by Sleeper (numeric or character)}

\item{type}{Type of data returned ("all", "team", "player") (string).}
}
\value{
If type is "all", will return a list containing data frames for
        both team and player data. Otherwise, will return team or player
        data depending on what is specified in the type argument. Note that
        with the player data, the aggregated player points could differ
        from the total team points due to the custom (manual) points that
        can be present.
}
\description{
Given a league ID and the type of data (all, team, or player data),
grab the matchup data for each week that matchup data is available.
}
\examples{
\dontrun{get_weekly_matchups(688281863499907072)}
\dontrun{get_weekly_matchups(688281863499907072, type = "player")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, April 2024
}
\keyword{league}
\keyword{matchups}
