% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slcaControl.R
\name{slcaControl}
\alias{slcaControl}
\title{Control Parameters for slca Estimation}
\usage{
slcaControl(
  em.iterlim = 3000,
  em.tol = 1e-06,
  nlm.iterlim = 1000,
  nlm.tol = 1e-08,
  init.param = NULL,
  nrep = 1,
  test.iter = 200,
  na.rm = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{em.iterlim}{an integer specifying maximum number of iterations allowed for EM algorithm. Default is 3000.}

\item{em.tol}{a numeric value setting tolerance for the convergence of EM algorithm. Default is 1e-6.}

\item{nlm.iterlim}{an integer specifying maximum number of iterations allowed for estimation with \code{nlm} function. Default is 1000.}

\item{nlm.tol}{a numeric value setting tolerance for the convergence of \code{nlm} function. Default is 1e-8.}

\item{init.param}{initial parameters.}

\item{nrep}{number of trials. Default is 1.}

\item{test.iter}{an integer specifying maximum number of iterations allowed for testing parameters. Default is 200}

\item{na.rm}{a logical value indicating whether to remove observations including missing values (NA)}

\item{verbose}{a logical value indicating whether to display progress updates during the estimation process}
}
\value{
a \code{list} with control parameters for slca estimation.
}
\description{
Control Parameters for slca Estimation
}
\seealso{
\link{slca}
}
