% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_slackr.R
\name{ggslackr}
\alias{ggslackr}
\title{Post a ggplot to a Slack channel}
\usage{
ggslackr(
  plot = last_plot(),
  channels = Sys.getenv("SLACK_CHANNEL"),
  scale = 1,
  width = par("din")[1],
  height = par("din")[2],
  units = c("in", "cm", "mm"),
  dpi = 300,
  limitsize = TRUE,
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN"),
  file = "ggplot",
  ...
)
}
\arguments{
\item{plot}{ggplot object to save, defaults to last plot displayed}

\item{channels}{list of channels to post image to}

\item{scale}{scaling factor}

\item{width}{width (defaults to the width of current plotting window)}

\item{height}{height (defaults to the height of current plotting window)}

\item{units}{units for width and height when either one is explicitly specified
(in, cm, or mm)}

\item{dpi}{dpi to use for raster graphics}

\item{limitsize}{when TRUE (the default), ggsave will not save images larger
than 50x50 inches, to prevent the common error of specifying dimensions in pixels.}

\item{bot_user_oauth_token}{the Slack bot user OAuth token (chr)}

\item{file}{prefix for filenames (defaults to \code{ggplot})}

\item{...}{other arguments passed to graphics device}
}
\value{
\code{httr} response object (invisibly)
}
\description{
Unlike the \code{\link[=slackr_dev]{slackr_dev()}} function, this one takes a \code{ggplot} object,
eliminating the need to have a graphics device (think use in scripts).
}
\examples{
\dontrun{
slackr_setup()
ggslackr(qplot(mpg, wt, data=mtcars))
}
}
