% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_slackr.R, R/zcamels.r
\name{dev_slackr}
\alias{dev.slackr}
\alias{dev_slackr}
\title{Send the graphics contents of the current device to a Slack channel}
\usage{
dev_slackr(channels = Sys.getenv("SLACK_CHANNEL"), ...,
  api_token = Sys.getenv("SLACK_API_TOKEN"), file = "plot")

dev.slackr(channels = Sys.getenv("SLACK_CHANNEL"), ...,
  api_token = Sys.getenv("SLACK_API_TOKEN"), file = "plot")
}
\arguments{
\item{channels}{list of channels to post image to}

\item{...}{other arguments passed into png device}

\item{api_token}{the slack.com full API token (chr)}

\item{file}{prefix for filenames (defaults to \code{plot})}
}
\value{
\code{httr} response object from \code{POST} call
}
\description{
\code{dev.slackr} sends the graphics contents of the current device to the
specified Slack channel.
}
\note{
You can pass in \code{add_user=TRUE} as part of the \code{...} parameters and the Slack API
      will post the message as your logged-in user account (this will override anything set in
      \code{username})
}
\examples{
\dontrun{
slackr_setup()

# base
library(maps)
map("usa")
dev_slackr("#results", filename='map')

# base
barplot(VADeaths)
dev_slackr("@jayjacobs")
}
}
\author{
Konrad Karczewski [ctb], Bob Rudis [aut]
}
\references{
\url{https://github.com/hrbrmstr/slackr/pull/12/files}
}
\seealso{
\code{\link{slackrSetup}}, \code{\link{save.slackr}}, \code{\link{slackrUpload}}
}

