% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars-data.R
\docType{data}
\name{stars}
\alias{stars}
\title{Stellar Data}
\format{A data frame with 103 rows and 13 variables:
 \describe{
   \item{HIP.ID}{Hipparchus Catalogue ID}
   \item{HR.ID}{Bright Star Catalogue ID}
   \item{MESSIER.ID}{Messier Catalogue ID}
   \item{BAYER.DESIGNATION}{Bayer Designation}
   \item{BAYER}{Bayer label}
   \item{CONSTELLATION}{Constellation star belongs to}
   \item{NAME}{Common Name}
   \item{VMAG}{Apparent Magnitude}
   \item{RA}{Right Ascension}
   \item{DEC}{Declination}
   \item{PM_RA}{Proper Motion in RA}
   \item{PM_DEC}{Proper Motion in DEC}
   \item{COLOUR}{Colour}
   }}
\usage{
data(stars)
}
\description{
Data on about one hundred brightest stars and clusters taken
from the \emph{Bright Star Catalog, 5th Edition}. It includes Name,
Constellation, Bayer Designation, Apparent Magnitude, Right
Ascension, Declination, Proper Motion (in both RA and Dec)
and Colour. Coordinates are given for J2000 epoch.
}
\examples{
data(stars)
stars$VMAG[stars$NAME == 'Sirius']
}
\references{
Hoffleit, D.; Jaschek, C. (1991). \emph{The Bright star catalogue}. New Haven: Yale University Observatory.
(\href{http://tdc-www.harvard.edu/catalogs/bsc5.html}{Bright Star Catalogue})
}
\keyword{datasets}
