% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-entry.R
\name{mag.dec}
\alias{mag.dec}
\title{Estimates magnetics declination (diff. between true and magnetic
north) based on IGRF 12th gen model}
\usage{
mag.dec(loc, date)
}
\arguments{
\item{loc}{Location, can be either a \emph{skyscapeR.horizon} object or, alternatively,
a latitude.}

\item{date}{Date for which to calculate magnetic declination in the format: 'YYYY/MM/DD'}
}
\description{
This function estimates the magnetic declination at a given location
and moment in time, using the \emph{12th generation International
Geomagnetic Reference Field (IGRF)} model. This function is a wrapper
for function \code{\link[oce]{magneticField}} of package \emph{oce}.
}
\examples{
# Magnetic Declination for London on April 1st 2016:
london.lat <- 51.5074 #N
london.lon <- -0.1278 #W
loc <- c( london.lat, london.lon )
mag.dec( loc, "2016/04/01" )
}
\seealso{
\code{\link[oce]{magneticField}}
}
