% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harrison_mccabe.R
\name{harrison_mccabe}
\alias{harrison_mccabe}
\title{Harrison and McCabe's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
harrison_mccabe(
  mainlm,
  deflator = NA,
  m = 0.5,
  alternative = c("less", "greater", "two.sided"),
  twosidedmethod = c("doubled", "kulinskaya"),
  qfmethod = "imhof",
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NA} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{m}{Either a \code{double} giving the proportion of the \eqn{n}
diagonal elements of \eqn{A} that are ones, or an \code{integer}
giving the index \eqn{m} up to which the diagonal elements are ones.
Defaults to \code{0.5}.}

\item{alternative}{A character specifying the form of alternative
hypothesis. If it is suspected that the error variance is positively
associated with the deflator variable, \code{"less"}. If it is
suspected that the error variance is negatively associated with deflator
variable, \code{"greater"}. If no information is available on the suspected
direction of the association, \code{"two.sided"}. Defaults to
\code{"less"}.}

\item{twosidedmethod}{A character indicating the method to be used to compute
two-sided \eqn{p}-values for the parametric test when \code{alternative}
is \code{"two.sided"}. The argument is passed to
\code{\link{twosidedpval}} as its \code{method} argument.}

\item{qfmethod}{A character, either \code{"imhof"}, \code{"davies"}, or
\code{"integrate"}, corresponding to the \code{algorithm} argument
of \code{\link[skedastic]{pRQF}}. The default is \code{"imhof"}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the method of
   \insertCite{Harrison79;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The test assumes that heteroskedasticity, if present, is
   monotonically related to one of the explanatory variables (known as the
   deflator). The OLS residuals \eqn{e} are placed in increasing order of
   the deflator variable and we let \eqn{A} be an \eqn{n\times n} selector
   matrix whose first \eqn{m} diagonal elements are 1 and all other elements
   are 0. The alternative hypothesis posits that the error variance changes
   around index \eqn{m}. Under the null hypothesis of homoskedasticity, the
   ratio of quadratic forms \eqn{Q=\frac{e' A e}{e'e}} should be close to
   \eqn{\frac{m}{n}}. Since the test statistic \eqn{Q} is a ratio of
   quadratic forms in the errors, the Imhof algorithm is used to compute
   \eqn{p}-values (with normality of errors assumed).
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
harrison_mccabe(mtcars_lm, deflator = "qsec")

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link[lmtest:hmctest]{lmtest::hmctest}}, another
   implementation of the Harrison-McCabe Test. Note that the \eqn{p}-values
   from that function are simulated rather than computed from the
   distribution of a ratio of quadratic forms in normal random vectors.
}
