% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evans_king.R
\name{evans_king}
\alias{evans_king}
\title{Evans-King Tests for Heteroskedasticity in a Linear Regression Model}
\usage{
evans_king(
  mainlm,
  method = c("GLS", "LM"),
  deflator = NA,
  lambda_star = 5,
  qfmethod = "imhof",
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{method}{A character indicating which of the two tests derived in
\insertCite{Evans88;textual}{skedastic} should be implemented.
Possible values are \code{"GLS"} and \code{"LM"}; partial matching is
used (which is not case-sensitive).}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NA} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{lambda_star}{A double; coefficient representing the degree of
heteroskedasticity under the alternative hypothesis.
\insertCite{Evans85;textual}{skedastic} suggests 2.5, 5, 7.5, and 10 as
values to consider, and \insertCite{Evans88;textual}{skedastic} finds
that 2.5 and 5 perform best empirically. This parameter is used only for
the \code{"GLS"} method; the \code{"LM"} method represents the limiting
case as \eqn{\lambda^\star \to 0}. Defaults to \code{5}.}

\item{qfmethod}{A character, either \code{"imhof"}, \code{"davies"}, or
\code{"integrate"}, corresponding to the \code{algorithm} argument
of \code{\link[skedastic]{pRQF}}. The default is \code{"imhof"}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the two methods of
   \insertCite{Evans88;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The test entails putting the data rows in increasing order of
   some specified deflator (e.g., one of the explanatory variables) that
   is believed to be related to the error variance by some non-decreasing
   function. There are two statistics that can be used, corresponding to
   the two values of the \code{method} argument. In both cases the test
   statistic can be expressed as a ratio of quadratic forms in the errors,
   and thus the Imhof algorithm is used to compute \eqn{p}-values. Both
   methods involve a left-tailed test.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
evans_king(mtcars_lm, deflator = "qsec", method = "GLS")
evans_king(mtcars_lm, deflator = "qsec", method = "LM")

}
\references{
{\insertAllCited{}}
}
\seealso{
\insertCite{Evans85;textual}{skedastic}, which already anticipates
   one of the tests.
}
