% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{pDtrend}
\alias{pDtrend}
\title{Cumulative distribution function of nonparametric trend statistic \eqn{D}}
\usage{
pDtrend(
  k,
  n,
  lower.tail = TRUE,
  exact = (n <= 10),
  tiefreq = NA,
  override = FALSE
)
}
\arguments{
\item{k}{An integer of \code{length} \eqn{\ge 1}
or a character \code{"all"} indicating that the cumulative
distribution function should be applied to the entire support of \eqn{D}.
The latter is only acceptable when \code{exact} is \code{TRUE}, since
the distribution is otherwise continuous.}

\item{n}{A positive integer representing the number of observations in the
series.}

\item{lower.tail}{A logical. Should lower tailed cumulative probability be
calculated? Defaults to \code{TRUE}. Note that both lower- and upper-
tailed cumulative probabilities are computed inclusive of \code{k}.}

\item{exact}{A logical. Should exact distribution of \eqn{D} be used by
calling \code{\link{dDtrend}}? If \code{FALSE}, a normal approximation
is used. If \code{tiefreq} is not \code{NA} (ties are present),
normal approximation is used regardless of the value of \code{exact}.
By default, \code{exact} is set to \code{TRUE} provided that
\code{n <= 10}. Setting \code{exact} to \code{TRUE} for \code{n > 11}
results in an error unless \code{override} is set to \code{TRUE}.}

\item{tiefreq}{A double vector corresponding to the value of \eqn{d_i}
in \insertCite{Lehmann75;textual}{skedastic}. These are the frequencies
of the various tied ranks. If ties are absent, \code{NA} (the default).}

\item{override}{A logical. By default, the \code{dDtrend} function aborts if
\eqn{n > 11} due to the prohibitively slow computation (which may cause
some systems to crash). Setting this argument to \code{TRUE} overrides
the abort. Ignored unless \code{exact} is \code{TRUE}.}
}
\value{
A double between 0 and 1 representing the probability/ies of \eqn{D}
   taking on at least (at most) the value(s) in the \code{names} attribute.
}
\description{
This function computes \eqn{\Pr(D \le k)} (\eqn{\Pr(D \ge k)}), i.e.
lower (upper) cumulative probabilities for
\eqn{D=\sum_{i=1}^{n} (R_i - i)^2}, the nonparametric trend statistic
proposed by \insertCite{Lehmann75;textual}{skedastic}, under the assumption
that the ranks \eqn{R_i} are computed on a series of \eqn{n} independent and
identically distributed random variables with no ties. The function may be
used to compute one-sided \eqn{p}-values for the nonparametric test for
heteroskedasticity of \insertCite{Horn81;textual}{skedastic}. Computation
time is extremely slow for \eqn{n > 10} if \code{usedata} is set to
\code{FALSE}; thus a normal approximation is implemented, including a
continuity correction.
}
\examples{
# For an independent sample of size 9, the probability that D is <= 50 is
# 0.05399857
pDtrend(k = 50, n = 9)
# Normal approximation of the above with continuity correction is
# 0.05193808
pDtrend(k = 50, n = 9, exact = FALSE)
# For an independent sample of size 50, the probability that D is >= 20000 is
# is 0.6093583
pDtrend(k = 2e4, n = 50, lower.tail = FALSE)

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link{dDtrend}}, \code{\link{horn}}
}
