% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_to_rr.R
\name{odds_to_rr}
\alias{odds_to_rr}
\title{Get relative risks estimates from logistic regressions}
\usage{
odds_to_rr(fit)
}
\arguments{
\item{fit}{A fitted binomial generalized linear (mixed) model with logit-link function
(logistic (multilevel) regression model).}
}
\value{
A data frame with relative risks and lower/upper confidence interval for
          the relative risks estimates.
}
\description{
This function converts odds ratios from a logistic regression
               model (including mixed models) into relative risks.
}
\details{
This function extracts the odds ratios (exponentiated model coefficients)
           from logistic regressions (fitted with \code{glm} or \code{glmer})
           and their related confidence intervals, and transforms these values
           into relative risks (and their related confidence intervals).
           \cr \cr
           The formula for transformation is based on Zhang and Yu (1998):
           \code{RR <- OR / ((1 - P0) + (P0 * OR))}, where \code{OR} is the odds
           ratio and \code{P0} indicates the proportion of the incidence in
           the outcome variable.
}
\examples{
library(sjmisc)
library(lme4)
# create binary response
sleepstudy$Reaction.dicho <- dicho(sleepstudy$Reaction, dich.by = "median")
# fit model
fit <- glmer(Reaction.dicho ~ Days + (Days | Subject),
             data = sleepstudy, family = binomial("logit"))
# convert to relative risks
odds_to_rr(fit)


data(efc)
# create binary response
y <- ifelse(efc$neg_c_7 < median(na.omit(efc$neg_c_7)), 0, 1)
# create data frame for fitted model
mydf <- data.frame(y = as.factor(y),
                   sex = efc$c161sex,
                   dep = to_factor(efc$e42dep),
                   barthel = efc$barthtot,
                   education = to_factor(efc$c172code))
# fit model
fit <- glm(y ~., data = mydf, family = binomial(link = "logit"))
# convert to relative risks
odds_to_rr(fit)

}
\references{
Zhang J, Yu KF. 1998. What's the Relative Risk? A Method of Correcting the Odds Ratio in Cohort Studies of Common Outcomes. JAMA; 280(19): 1690-1. \doi{10.1001/jama.280.19.1690}
}
