% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.R
\name{se}
\alias{se}
\title{Standard Error for variables}
\usage{
se(x)
}
\arguments{
\item{x}{(Numeric) vector, a data frame or a \code{merMod}-object
as returned by the \code{\link[lme4]{lmer}}-method.}
}
\value{
The standard error of \code{x}, or for each variable
          if \code{x} is a data frame, or for the coefficients
          of a mixed model (see \code{\link[lme4]{coef.merMod}}).
}
\description{
Compute standard error for a variable, for all variables
               of a data frame or for joint random and fixed effects
               coefficients of mixed models.
}
\details{
Unlike \code{\link[arm]{se.coef}}, which returns the standard error
           for fixed and random effects separately, this function computes
           the standard errors for joint (sums of) random and fixed
           effects coefficients. Hence, \code{se} returns the appropriate
           standard errors for \code{\link[lme4]{coef.merMod}}.
}
\note{
Computation of standard errors for coefficients of mixed models
        is based \href{http://stackoverflow.com/questions/26198958/extracting-coefficients-and-their-standard-error-from-lme}{on this code}.
}
\examples{
se(rnorm(n = 100, mean = 3))

data(efc)
se(efc[, 1:3])

library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
se(fit)

}

