% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.R, R/xtab_statistics.R
\name{phi}
\alias{phi}
\alias{cramer}
\alias{cramer.formula}
\alias{xtab_statistics}
\title{Measures of association for contingency tables}
\usage{
phi(tab)

cramer(tab, ...)

\method{cramer}{formula}(formula, data, ...)

xtab_statistics(data, x1 = NULL, x2 = NULL, statistics = c("auto",
  "cramer", "phi", "spearman", "kendall", "pearson", "fisher"),
  weights = NULL, ...)
}
\arguments{
\item{tab}{A \code{\link{table}} or \code{\link[stats]{ftable}}. Tables of class
\code{\link[stats]{xtabs}} and other will be coerced to \code{ftable}
objects.}

\item{...}{Other arguments, passed down to the statistic functions
\code{\link[stats]{chisq.test}}, \code{\link[stats]{fisher.test}} or
\code{\link[stats]{cor.test}}.}

\item{formula}{A formula of the form \code{lhs ~ rhs} where \code{lhs} is a
numeric variable giving the data values and \code{rhs} a factor giving the
corresponding groups.}

\item{data}{A data frame or a table object. If a table object, \code{x1} and
\code{x2} will be ignored. For Kendall's \emph{tau}, Spearman's \emph{rho}
or Pearson's product moment correlation coefficient, \code{data} needs
to be a data frame. If \code{x1} and \code{x2} are not specified,
the first two columns of the data frames are used as variables
to compute the crosstab.}

\item{x1}{Name of first variable that should be used to compute the
contingency table. If \code{data} is a table object, this argument
will be irgnored.}

\item{x2}{Name of second variable that should be used to compute the
contingency table. If \code{data} is a table object, this argument
will be irgnored.}

\item{statistics}{Name of measure of association that should be computed. May
be one of \code{"auto"}, \code{"cramer"}, \code{"phi"}, \code{"spearman"},
\code{"kendall"}, \code{"pearson"} or \code{"fisher"}. See 'Details'.}

\item{weights}{Name of variable in \code{x} that indicated the vector of
weights that will be applied to weight all observations. Default is
\code{NULL}, so no weights are used.}
}
\value{
For \code{phi()}, the table's Phi value. For \code{cramer()}, the
        table's Cramer's V.
        \cr \cr
        For \code{xtab_statistics()}, a list with following components:
        \describe{
          \item{\code{estimate}}{the value of the estimated measure of association.}
          \item{\code{p.value}}{the p-value for the test.}
          \item{\code{statistic}}{the value of the test statistic.}
          \item{\code{stat.name}}{the name of the test statistic.}
          \item{\code{stat.html}}{if applicable, the name of the test statistic, in HTML-format.}
          \item{\code{df}}{the degrees of freedom for the contingency table.}
          \item{\code{method}}{character string indicating the name of the measure of association.}
          \item{\code{method.html}}{if applicable, the name of the measure of association, in HTML-format.}
          \item{\code{method.short}}{the short form of association measure, equals the \code{statistics}-argument.}
          \item{\code{fisher}}{logical, if Fisher's exact test was used to calculate the p-value.}
        }
}
\description{
This function calculates various measure of association for
             contingency tables and returns the statistic and p-value.
             Supported measures are Cramer's V, Phi, Spearman's rho,
             Kendall's tau and Pearson's r.
}
\details{
The p-value for Cramer's V and the Phi coefficient are based
         on \code{chisq.test()}. If any expected value of a table cell is
         smaller than 5, or smaller than 10 and the df is 1, then \code{fisher.test()}
         is used to compute the p-value, unless \code{statistics = "fisher"}; in
         this case, the use of \code{fisher.test()} is forced to compute the
         p-value. The test statistic is calculated with \code{cramer()} resp.
         \code{phi()}.
         \cr \cr
         Both test statistic and p-value for Spearman's rho, Kendall's tau
         and Pearson's r are calculated with \code{cor.test()}.
         \cr \cr
         When \code{statistics = "auto"}, only Cramer's V or Phi are calculated,
         based on the dimension of the table (i.e. if the table has more than
         two rows or columns, Cramer's V is calculated, else Phi).
}
\examples{
# Phi coefficient for 2x2 tables
tab <- table(sample(1:2, 30, TRUE), sample(1:2, 30, TRUE))
phi(tab)

# Cramer's V for nominal variables with more than 2 categories
tab <- table(sample(1:2, 30, TRUE), sample(1:3, 30, TRUE))
cramer(tab)

data(efc)
# 2x2 table, compute Phi automatically
xtab_statistics(efc, e16sex, c161sex)

# more dimensions than 2x2, compute Cramer's V automatically
xtab_statistics(efc, c172code, c161sex)

# ordinal data, use Kendall's tau
xtab_statistics(efc, e42dep, quol_5, statistics = "kendall")

# calcilate Spearman's rho, with continuity correction
xtab_statistics(efc,
  e42dep,
  quol_5,
  statistics = "spearman",
  exact = FALSE,
  continuity = TRUE
)

}
