% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_accuracy.R
\name{pred_accuracy}
\alias{pred_accuracy}
\title{Accuracy of predictions from model fit}
\usage{
pred_accuracy(data, fit, method = c("cv", "boot"), k = 5, n = 1000)
}
\arguments{
\item{data}{A data frame.}

\item{fit}{Fitted model object of class \code{lm} or \code{glm}, the latter
being a logistic regression model (binary response).}

\item{method}{Character string, indicating whether crossvalidation
(\code{method = "cv"}) or bootstrapping (\code{method = "boot"})
is used to compute the accuracy values.}

\item{k}{The number of folds for the kfold-crossvalidation.}

\item{n}{Number of bootstraps to be generated.}
}
\value{
A list with two values: The \code{accuracy} of the model predictions, i.e.
        the proportion of accurately predicted values from the model and
        its standard error, \code{std.error}.
}
\description{
This function calculates the predictive accuracy of linear
             or logistic regression models.
}
\details{
For linar models, the accuracy is the correlation coefficient
         between the actual and the predicted value of the outcome. For
         logistic regression models, the accuracy corresponds to the
         AUC-value, calculated with the \code{\link[pROC]{auc}}-function.
         \cr \cr
         The accuracy is the mean value of multiple correlation resp.
         AUC-values, which are either computed with crossvalidation
         or nonparametric bootstrapping (see argument \code{method}).
         The standard error is the standard deviation of the computed
         correlation resp. AUC-values.
}
\examples{
data(efc)
fit <- lm(neg_c_7 ~ barthtot + c161sex, data = efc)

# accuracy for linear model, with crossvalidation
pred_accuracy(efc, fit)

# accuracy for linear model, with bootstrapping
pred_accuracy(efc, fit, method = "boot", n = 100)

# accuracy for logistic regression, with crossvalidation
efc$services <- sjmisc::dicho(efc$tot_sc_e, dich.by = 0, as.num = TRUE)
fit <- glm(services ~ neg_c_7 + c161sex + e42dep,
           data = efc, family = binomial(link = "logit"))
pred_accuracy(efc, fit)

}
\seealso{
\code{\link{cv_error}}
}
