% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typical.R
\name{typical_value}
\alias{typical_value}
\title{Return the typical value of a vector}
\usage{
typical_value(x, fun = c("mean", "median", "mode", "weighted.mean"), ...)
}
\arguments{
\item{x}{A variable.}

\item{fun}{Character vector, naming the function to be applied to numeric
\code{x}. Currently, \code{"mean"}, \code{"weighted.mean"},
\code{"median"} and \code{"mode"} are supported, which call the
corresponding R functions (except \code{"mode"}, which calls an
internal function to compute the most common value).}

\item{...}{Further arguments, passed down to \code{fun}.}
}
\value{
The "typical" value of \code{x}.
}
\description{
This function returns the "typical" value of a variable.
}
\details{
By default, for numeric variables, \code{typical_value()} returns the
         mean value of \code{x} (unless changed with the \code{fun}-argument).
         For factors, the reference level and for character vectors, to the
         most common value (mode) is returned.
}
\examples{
data(iris)
typical_value(iris$Sepal.Length)

library(purrr)
map(iris, ~ typical_value(.x))

# example from ?stats::weighted.mean
wt <- c(5,  5,  4,  1) / 15
x <- c(3.7, 3.3, 3.5, 2.8)

typical_value(x, "weighted.mean")
typical_value(x, "weighted.mean", w = wt)

}
