% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R
\name{add_labels}
\alias{add_labels}
\alias{add_labels<-}
\title{Add value labels to variables}
\usage{
add_labels(x, value)

add_labels(x) <- value
}
\arguments{
\item{x}{Variable (vector), \code{list} of variables or a \code{data.frame}
where value label attributes should be added. Does not replaces former
value labels.}

\item{value}{Named character vector of labels that will be added to \code{x} as
\code{"labels"} or \code{"value.labels"} attribute. If \code{x} is
a data frame, \code{value} may also be a \code{\link{list}} of
named character vectors. If \code{value} is a list, it must have
the same length as number of columns of \code{x}. If \code{value}
is a vector and \code{x} is a data frame, \code{value} will be applied
to each column of \code{x}.}
}
\value{
\code{x} with additional value labels.
}
\description{
This function adds additional labels as attribute to a variable
               or vector \code{x}, resp. to a set of variables in a
               \code{data.frame} or \code{list}-object. Unlike \code{\link{set_labels}},
               \code{add_labels} does not replace existing value labels, but adds
               \code{value} to the existing value labels of \code{x}.
}
\note{
Existing labelled values will be replaced by new labelled values
        in \code{value}. See 'Examples'.
}
\examples{
data(efc)
get_labels(efc$e42dep)

x <- add_labels(efc$e42dep, c(`nothing` = 5))
get_labels(x)

x <- add_labels(efc$e42dep, c(`nothing` = 5, `zero value` = 0))
get_labels(x, include.values = "p")

# replace old values
x <- add_labels(efc$e42dep, c(`not so dependent` = 4, `lorem ipsum` = 5))
get_labels(x, include.values = "p")

# replace values, alternative function call
add_labels(x) <- c(`new second` = 2)


}
\seealso{
\code{\link{set_label}} to manually set variable labels or
           \code{\link{get_label}} to get variable labels; \code{\link{set_labels}} to
           add value labels, replacing the existing ones.
}

