% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{to_fac}
\alias{to_fac}
\title{Convert variable into factor and keep value labels}
\usage{
to_fac(x)
}
\arguments{
\item{x}{A (numeric or atomic) variable or a data frame with
(numeric or atomic) variables.}
}
\value{
A factor variable, including variable and value labels, respectively
          a data frame with factor variables (including variable and value labels)
          if \code{x} was a data frame.
}
\description{
This function converts a variable into a factor, but keeps
               variable and value labels, if these are attached as attributes
               to the variale. See examples.
}
\note{
This function is intended for use with vectors that have value and variable
       labels attached. Unlike \code{\link{as.factor}}, \code{to_fac} converts
       a variable into a factor and retains the value and variable label attributes.
       \cr \cr
       Attaching labels is automatically done by importing data sets
       with one of the \code{read_*}-functions, like \code{\link{read_spss}}.
       Else, value and variable labels can be manually added to vectors
       with \code{\link{set_val_labels}} and \code{\link{set_var_labels}}.
}
\examples{
\dontrun{
data(efc)
library(sjPlot)
# normal factor conversion, loses value attributes
efc$e42dep <- as.factor(efc$e42dep)
sjt.frq(efc$e42dep)

data(efc)
# factor conversion, which keeps value attributes
efc$e42dep <- to_fac(efc$e42dep)
sjt.frq(efc$e42dep)}
}
\seealso{
\code{\link{to_value}} to convert a factor into a numeric value and
           \code{\link{to_label}} to convert a value into a factor with labelled
           factor levels.
}

