% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_values.R
\name{get_values}
\alias{get_values}
\title{Retrieve values of labelled variables}
\usage{
get_values(x, sort.val = TRUE, drop.na = FALSE)
}
\arguments{
\item{x}{Variable (vector) with value label attributes; or a data frame or
list with such variables.}

\item{sort.val}{Logical, if \code{TRUE} (default), values of associated value labels
are sorted.}

\item{drop.na}{Logical, if \code{TRUE}, tagged NA values are excluded from
the return value. See 'Examples' and \code{\link{get_na}}.}
}
\value{
The values associated with value labels from \code{x},
          or \code{NULL} if \code{x} has no label attributes.
}
\description{
This function retrieves the values associated with value labels
               from \code{\link[haven]{labelled}} vectors. Data is also labelled
               when imported from SPSS, SAS or STATA via \code{\link{read_spss}},
               \code{\link{read_sas}} or \code{\link{read_stata}}.
}
\details{
\code{\link[haven]{labelled}} vectors are numeric by default (when imported with read-functions
           like \code{\link{read_spss}}) and have variable and value labels attributes.
           The value labels are associated with those values from the labelled vector.
           This function returns the values associated with the vector's value labels,
           which may differ from actual values in the vector (e.g. if not all
           values have a related label).
}
\examples{
data(efc)
str(efc$e42dep)
get_values(efc$e42dep)
get_labels(efc$e42dep)

library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get all values
get_values(x)
# drop NA
get_values(x, drop.na = TRUE)

# data frame as input
y <- labelled(c(2:3, 3:1, tagged_na("y"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "Why" = tagged_na("y")))
get_values(data.frame(x, y))

}
\seealso{
\code{\link{get_labels}} for getting value labels and \code{\link{get_na}}
           to get values for missing values.
}
