% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_pob_incidencia}
\alias{import_pob_incidencia}
\title{Importar la población para efectuar el cálculo de la incidencia}
\usage{
import_pob_incidencia(
  poblacion = c("riesgo", "proyecciones"),
  event,
  year,
  ruta_dir = NULL,
  cache = FALSE
)
}
\arguments{
\item{poblacion}{Un `character` (cadena de caracteres) con el tipo de
población que se desea importar. Puede ser `"riesgo"` para la población
a riesgo del evento o `"proyecciones"` para las proyecciones poblacionales
DANE; su valor por defecto es `"riesgo"`.}

\item{event}{Un `character` (cadena de caracteres) o un `numeric` (numérico)
con el nombre o código de la enfermedad o evento. Es obligatorio para
importar la población a riesgo.}

\item{year}{Un `numeric` (numérico) con el año deseado de la población a
riesgo. Es obligatorio para importar la población a riesgo.}

\item{ruta_dir}{Un `character` (cadena de caracteres) que especifica la ruta
del directorio donde se almacenarán la población a riesgo o las proyecciones
poblacionales DANE. Su valor por defecto es `NULL`.}

\item{cache}{Un `logical` (`TRUE` o `FALSE`) que indica si la población a
riesgo o las proyecciones poblacionales DANE descargadas deben ser
almacenados en caché. Su valor por defecto es `FALSE`.}
}
\value{
Un `data.frame` con la población a riesgo o las proyecciones
poblacionales DANE.
}
\description{
Función que importa la población a riesgo de un evento o
enfermedad o las proyecciones poblacionales DANE desde el año 2005 hasta
el 2035.
}
\examples{
 \donttest{
# Importación proyecciones poblaciones DANE
import_pob_incidencia(poblacion = "proyecciones", year = 2020,
                      cache = TRUE)
# Importación población a riesgo de Dengue del año 2020
import_pob_incidencia(poblacion = "riesgo", event = "dengue", year = 2020,
                      ruta_dir = tempdir())
}
}
