% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_terra.R
\name{sits_as_terra}
\alias{sits_as_terra}
\alias{sits_as_terra.raster_cube}
\alias{sits_as_terra.probs_cube}
\alias{sits_as_terra.class_cube}
\alias{sits_as_terra.variance_cube}
\alias{sits_as_terra.uncertainty_cube}
\title{Convert a data cube into a Spatial Raster object from terra}
\usage{
sits_as_terra(cube, tile = cube[1L, ]$tile, ...)

\method{sits_as_terra}{raster_cube}(cube, tile = cube[1L, ]$tile, ..., bands = NULL, date = NULL)

\method{sits_as_terra}{probs_cube}(cube, tile = cube[1L, ]$tile, ...)

\method{sits_as_terra}{class_cube}(cube, tile = cube[1L, ]$tile, ...)

\method{sits_as_terra}{variance_cube}(cube, tile = cube[1L, ]$tile, ...)

\method{sits_as_terra}{uncertainty_cube}(cube, tile = cube[1L, ]$tile, ...)
}
\arguments{
\item{cube}{A sits cube.}

\item{tile}{Tile of the data cube.}

\item{...}{Other parameters for specific types of data cubes.}

\item{bands}{Bands of the data cube to be part of \code{terra} object.}

\item{date}{Date of the data cube to be part of \code{terra} object.}
}
\value{
An Spatial Raster object from \code{terra}.
}
\description{
Uses the information about files, bands and dates
in a data cube to produce an object of class \code{terra}.
User has to select a tile and a date from the data cube. By default,
all bands are included in the \code{terra} object.
Users can select bands.
}
\examples{
if (sits_run_examples()) {
    # convert sits cube to an sf object (polygon)
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    spat_raster <- sits_as_terra(cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara.inpe@gmail.com}
}
