% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_cube_copy.R
\name{sits_cube_copy}
\alias{sits_cube_copy}
\title{Copy the images of a cube to a local directory}
\usage{
sits_cube_copy(
  cube,
  roi = NULL,
  res = NULL,
  crs = NULL,
  n_tries = 3L,
  multicores = 2L,
  output_dir,
  progress = TRUE
)
}
\arguments{
\item{cube}{A data cube (class "raster_cube")}

\item{roi}{Region of interest. Either:
\enumerate{
\item{A path to a shapefile with polygons;}
\item{A \code{sf} object from \code{sf} package;}
\item{A named \code{vector} (\code{"lon_min"},
      \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"})
      in WGS84;}
\item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
      \code{"ymin"}, \code{"ymax"}) with XY coordinates
      in WGS84.}
 }}

\item{res}{An integer value corresponds to the output
spatial resolution of the images. Default is NULL.}

\item{crs}{The Coordinate Reference System (CRS) of the roi.
(see details below).}

\item{n_tries}{Number of attempts to download the same image.
Default is 3.}

\item{multicores}{Number of cores for parallel downloading
(integer, min = 1, max = 2048).}

\item{output_dir}{Output directory where images will be saved.
(character vector of length 1).}

\item{progress}{Logical: show progress bar?}
}
\value{
Copy of input data cube (class "raster cube").

The main \code{sits} classification workflow has the following steps:
\enumerate{
     \item{\code{\link[sits]{sits_cube}}: selects a ARD image collection from
         a cloud provider.}
     \item{\code{\link[sits]{sits_cube_copy}}: copies an ARD image collection
         from a cloud provider to a local directory for faster processing.}
     \item{\code{\link[sits]{sits_regularize}}: create a regular data cube
         from an ARD image collection.}
     \item{\code{\link[sits]{sits_apply}}: create new indices by combining
         bands of a  regular data cube (optional).}
     \item{\code{\link[sits]{sits_get_data}}: extract time series
         from a regular data cube based on user-provided labelled samples.}
     \item{\code{\link[sits]{sits_train}}: train a machine learning
         model based on image time series.}
     \item{\code{\link[sits]{sits_classify}}: classify a data cube
         using a machine learning model and obtain a probability cube.}
     \item{\code{\link[sits]{sits_smooth}}: post-process a probability cube
         using a spatial smoother to remove outliers and
         increase spatial consistency.}
     \item{\code{\link[sits]{sits_label_classification}}: produce a
         classified map by selecting the label with the highest probability
         from a smoothed cube.}
}

The \code{roi} parameter is used to crop cube images. To define a \code{roi}
use one of:
\itemize{
     \item{A path to a shapefile with polygons;}
     \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
     \item{A \code{SpatExtent} object from \code{terra} package;}
     \item{A named \code{vector} (\code{"lon_min"},
           \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
     \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
         \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
 }
Defining a region of interest using \code{SpatExtent} or XY values not in
WGS84 requires the \code{crs} parameter to be specified.
}
\description{
This function downloads the images of a cube in parallel.
A region of interest (\code{roi}) can be provided to crop
the images and a resolution (\code{res}) to resample the
bands. \code{sits_cube_copy} is useful to improve processing time in the
regularization operation.
}
\examples{
if (sits_run_examples()) {
    # Creating a sits cube from BDC
    bdc_cube <- sits_cube(
        source = "BDC",
        collection = "CBERS-WFI-16D",
        tiles = c("007004", "007005"),
        bands = c("B15", "CLOUD"),
        start_date = "2018-01-01",
        end_date = "2018-01-12"
    )
    # Downloading images to a temporary directory
    cube_local <- sits_cube_copy(
        cube = bdc_cube,
        output_dir = tempdir(),
        roi = c(
            lon_min = -46.5,
            lat_min = -45.5,
            lon_max = -15.5,
            lat_max = -14.6
        ),
        multicores = 2L,
        res = 250
    )
}

}
\author{
Felipe Carlos, \email{efelipecarlos@gmail.com}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
