% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_probs.R
\name{sits_get_probs}
\alias{sits_get_probs}
\alias{sits_get_probs.csv}
\alias{sits_get_probs.shp}
\alias{sits_get_probs.sf}
\alias{sits_get_probs.sits}
\alias{sits_get_probs.data.frame}
\alias{sits_get_probs.default}
\title{Get values from probability maps}
\usage{
sits_get_probs(cube, samples, window_size = NULL)

\method{sits_get_probs}{csv}(cube, samples, window_size = NULL)

\method{sits_get_probs}{shp}(cube, samples, window_size = NULL)

\method{sits_get_probs}{sf}(cube, samples, window_size = NULL)

\method{sits_get_probs}{sits}(cube, samples, window_size = NULL)

\method{sits_get_probs}{data.frame}(cube, samples, window_size = NULL)

\method{sits_get_probs}{default}(cube, samples, window_size = NULL)
}
\arguments{
\item{cube}{Probability data cube from where data is to be retrieved.
(class "class_cube").}

\item{samples}{Location of the samples to be retrieved.
Either a tibble of class "sits", an "sf" object,
the name of a shapefile or csv file, or
a data.frame with columns "longitude" and "latitude"}

\item{window_size}{Size of window around pixel (optional)}
}
\value{
A tibble of with columns
                       <longitude, latitude, values> in case no windows
                       are requested and <longitude, latitude, neighbors>
                       in case windows are requested
}
\description{
Given a set of lat/long locations and a probability cube,
retrieve the prob values of each point.
}
\note{
There are four ways of specifying data to be retrieved using the
\code{samples} parameter:
(a) CSV file: a CSV file with columns \code{longitude}, \code{latitude};
(b) SHP file: a shapefile in POINT geometry;
(c) sits object: A sits tibble;
(d) sf object: An \code{link[sf]{sf}} object with POINT or geometry;
(e) data.frame: A data.frame with \code{longitude} and \code{latitude}.
}
\author{
Gilberto Camara
}
