% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_segmentation.R
\name{sits_segment}
\alias{sits_segment}
\title{Segment an image}
\usage{
sits_segment(
  cube,
  seg_fn = sits_slic(),
  roi = NULL,
  start_date = NULL,
  end_date = NULL,
  memsize = 8,
  multicores = 2,
  output_dir,
  version = "v1",
  progress = TRUE
)
}
\arguments{
\item{cube}{Regular data cube}

\item{seg_fn}{Function to apply the segmentation}

\item{roi}{Region of interest (see below)}

\item{start_date}{Start date for the segmentation}

\item{end_date}{End date for the segmentation.}

\item{memsize}{Memory available for classification (in GB).}

\item{multicores}{Number of cores to be used for classification.}

\item{output_dir}{Directory for output file.}

\item{version}{Version of the output (for multiple
segmentations).}

\item{progress}{Show progress bar?}
}
\value{
A tibble of class 'segs_cube' representing the
segmentation.
}
\description{
Apply a spatial-temporal segmentation on a data cube based on a user defined
segmentation function. The function applies the segmentation algorithm
"seg_fn" to each tile.

Segmentation uses the following steps:
\enumerate{
 \item Create a regular data cube with \code{\link[sits]{sits_cube}} and
       \code{\link[sits]{sits_regularize}};
 \item Run \code{\link[sits]{sits_segment}} to obtain a vector data cube
       with polygons that define the boundary of the segments;
 \item Classify the time series associated to the segments
       with \code{\link[sits]{sits_classify}}, to get obtain
       a vector probability cube;
 \item Use \code{\link[sits]{sits_label_classification}} to label the
     vector probability cube;
 \item Display the results with \code{\link[sits]{plot}} or
       \code{\link[sits]{sits_view}}.
}
}
\note{
The "roi" parameter defines a region of interest. It can be
   an sf_object, a shapefile, or a bounding box vector with
   named XY values ("xmin", "xmax", "ymin", "ymax") or
   named lat/long values ("lon_min", "lat_min", "lon_max", "lat_max")
}
\examples{
if (sits_run_examples()) {
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    # create a data cube
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # segment the vector cube
    segments <- sits_segment(
        cube = cube,
        output_dir = tempdir()
    )
    # create a classification model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # classify the segments
    seg_probs <- sits_classify(
        data = segments,
        ml_model = rfor_model,
        output_dir = tempdir()
    )
    # label the probability segments
    seg_label <- sits_label_classification(
        cube = seg_probs,
        output_dir = tempdir()
    )
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
